/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.util.IOUtil;

class ArchiveHeader
implements ArchiveConstants {
    protected static final int TAG_OFFSET = 0;
    protected static final int VERSION_OFFSET = 8;
    protected static final int STATUS_OFFSET = 16;
    protected static final int BLOCK_SIZE_OFFSET = 20;
    protected static final int HEADER_LENGTH = 24;
    protected int fileStatus = 0;
    protected int blockSize;

    ArchiveHeader() {
        this.blockSize = 4096;
    }

    ArchiveHeader(int blockSize) {
        this.blockSize = blockSize;
    }

    int getStatus() {
        return this.fileStatus;
    }

    void setStatus(int status) {
        this.fileStatus = status;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    static ArchiveHeader read(RandomAccessFile rf) throws IOException {
        ArchiveHeader header = new ArchiveHeader();
        byte[] b = new byte[24];
        rf.seek(0L);
        rf.readFully(b);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        long magicTag = in.readLong();
        if (magicTag != 90504964424259L) {
            throw new IOException("Not a compound file, the magic code is " + magicTag);
        }
        long version = in.readLong();
        if (version != 0L) {
            throw new IOException("Unsupported compound archive version 0");
        }
        header.fileStatus = in.readInt();
        header.blockSize = in.readInt();
        if (header.blockSize == 0) {
            header.blockSize = 4096;
        }
        return header;
    }

    void refresh(ArchiveFileV2 af) throws IOException {
        byte[] b = new byte[4];
        af.read(0, 16, b, 0, 4);
        this.fileStatus = IOUtil.bytesToInteger((byte[])b);
    }

    void flush(ArchiveFileV2 af) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        out.writeLong(90504964424259L);
        out.writeLong(0L);
        out.writeInt(this.fileStatus);
        out.writeInt(this.blockSize);
        byte[] b = buffer.toByteArray();
        af.write(0, 0, b, 0, b.length);
    }
}

