/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.log;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.log.ILogger;

public final class DefaultLoggerImpl
implements ILogger {
    private static DefaultLoggerImpl dli = null;
    private int iVerboseLevel = 15;

    public static final synchronized ILogger instance() {
        if (dli == null) {
            dli = new DefaultLoggerImpl();
        }
        return dli;
    }

    private DefaultLoggerImpl() {
    }

    public final void setVerboseLevel(int iVerboseLevel) {
        this.iVerboseLevel = iVerboseLevel;
    }

    public final void logFromScript(String sMessage) {
        if ((this.iVerboseLevel & 1) == 1) {
            System.out.println(Messages.getString("info.log.script", new Object[]{sMessage}, ULocale.getDefault()));
        }
    }

    public void log(int iCode, String sMessage) {
        if (iCode == 1 && (this.iVerboseLevel & 1) == 1) {
            System.out.println(Messages.getString("info.log.info", new Object[]{sMessage}, ULocale.getDefault()));
        } else if (iCode == 2 && (this.iVerboseLevel & 2) == 2) {
            System.out.println(Messages.getString("info.log.warn", new Object[]{sMessage}, ULocale.getDefault()));
        } else if (iCode == 4 && (this.iVerboseLevel & 4) == 4) {
            System.err.println(Messages.getString("info.log.err", new Object[]{sMessage}, ULocale.getDefault()));
        } else if (iCode == 8 && (this.iVerboseLevel & 8) == 8) {
            System.err.println(Messages.getString("info.log.fatal", new Object[]{sMessage}, ULocale.getDefault()));
            System.exit(0);
        }
    }

    public void log(Exception ex) {
        System.err.println(Messages.getString("info.log.err", new Object[]{ex.toString()}, ULocale.getDefault()));
        ex.printStackTrace();
    }
}

