/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.birt.report.model.api.BundleFactory;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.BundleHelper;
import org.eclipse.birt.report.model.util.ModelUtil;

public class DefaultResourceLocator
implements IResourceLocator {
    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        URL u = null;
        if (fileName == null) {
            return u;
        }
        switch (type) {
            case 5: {
                u = this.getMessageFile(moduleHandle, fileName);
                break;
            }
            default: {
                u = this.getResource(moduleHandle, fileName);
            }
        }
        return u;
    }

    private URL getMessageFile(ModuleHandle moduleHandle, String fileName) {
        if (moduleHandle == null) {
            return null;
        }
        ULocale locale = moduleHandle.getModule().getSession().getLocale();
        List possibleFiles = BundleHelper.getHelper(moduleHandle.getModule(), fileName).getMessageFilenames(locale);
        int i = 0;
        while (i < possibleFiles.size()) {
            String filename = (String)possibleFiles.get(i);
            URL url = this.getResource(moduleHandle, filename);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    private URL getResource(ModuleHandle moduleHandle, String fileName) {
        URL retURL = this.tryDiskFileSearch(null, fileName);
        if (retURL != null) {
            return retURL;
        }
        try {
            retURL = this.tryURLSearch(new URL(fileName));
            if (retURL != null) {
                return retURL;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        if (moduleHandle == null) {
            return this.tryFragmentSearch(fileName);
        }
        String resourcePath = moduleHandle.getModule().getSession().getResourceFolder();
        if (StringUtil.isBlank(resourcePath)) {
            resourcePath = moduleHandle.getResourceFolder();
        }
        if (resourcePath != null) {
            retURL = this.tryDiskFileSearch(resourcePath, fileName);
            if (retURL != null) {
                return retURL;
            }
            try {
                URL baseURL = new URL(resourcePath);
                retURL = this.tryURLSearch(new URL(baseURL, URIUtil.convertFileNameToURLString(fileName)));
            }
            catch (MalformedURLException malformedURLException) {}
            if (retURL != null) {
                return retURL;
            }
        }
        if ((retURL = this.tryFragmentSearch(fileName)) != null) {
            return retURL;
        }
        URL systemId = moduleHandle.getModule().getSystemId();
        if (systemId == null) {
            return null;
        }
        try {
            return this.tryURLSearch(new URL(systemId, URIUtil.convertFileNameToURLString(fileName)));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isGlobalResource(URL url) {
        if ("ftp".equalsIgnoreCase(url.getProtocol()) || "http".equalsIgnoreCase(url.getProtocol())) {
            return true;
        }
        return url.getFile().toLowerCase().startsWith("ftp") || url.getFile().toLowerCase().startsWith("http");
    }

    /*
     * Exception decompiling
     */
    private URL tryURLSearch(URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 52->55)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL tryFragmentSearch(String fileName) {
        return BundleFactory.getBundleFactory().getBundleResource("org.eclipse.birt.resources", fileName);
    }

    private URL tryDiskFileSearch(String fileDir, String filePath) {
        File f = null;
        String tmpFilePath = ModelUtil.toUniversalFileFormat(filePath);
        f = StringUtil.isBlank(fileDir) ? new File(tmpFilePath) : new File(fileDir, tmpFilePath);
        try {
            if (f.exists() && f.isFile()) {
                return f.getCanonicalFile().toURL();
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

