/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ExtensionValidator
extends AbstractElementValidator {
    public static final String NAME = "ExtensionValidator";
    private static final ExtensionValidator instance = new ExtensionValidator();

    public static ExtensionValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof ExtendedItem)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (ExtendedItem)element);
    }

    private List doValidate(Module module, ExtendedItem toValidate) {
        List exceptions;
        ArrayList list = new ArrayList();
        if (!(toValidate.getExtendedElement() != null || module instanceof Library && ((Library)module).getHost() != null)) {
            try {
                toValidate.initializeReportItem(module);
            }
            catch (ExtendedElementException extendedElementException) {
                return list;
            }
        }
        if (toValidate.getExtendedElement() != null && (exceptions = toValidate.getExtendedElement().validate()) != null) {
            list.addAll(exceptions);
        }
        return list;
    }
}

