/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class MasterPageTypeValidator
extends AbstractElementValidator {
    private static MasterPageTypeValidator instance = new MasterPageTypeValidator();

    public static MasterPageTypeValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof MasterPage)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (MasterPage)element);
    }

    private List doValidate(Module module, MasterPage toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        String type = toValidate.getStringProperty(module, "type");
        String height = toValidate.getStringProperty(module, "height");
        String width = toValidate.getStringProperty(module, "width");
        if ("custom".equalsIgnoreCase(type) && (StringUtil.isBlank(height) || StringUtil.isBlank(width))) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.MISSING_PAGE_SIZE"));
        }
        return list;
    }
}

