/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.command.CssReloadedEvent;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.CssRecord;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class CssCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.CssCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CssCommand(Module module, DesignElement element) {
        super(module, element);
    }

    public void addCss(String fileName) throws SemanticException {
        try {
            CssStyleSheet sheet = this.module.loadCss(fileName);
            this.addCss(sheet);
        }
        catch (StyleSheetException styleSheetException) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.BADCSSFILE");
        }
    }

    public void addCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        if (this.getCssStyleSheetByLocation(fileName) != null) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.DUPLICATE_CSS");
        }
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startTrans();
        CssRecord record = new CssRecord(this.module, this.element, sheet, true);
        this.getActivityStack().execute(record);
        try {
            IncludedCssStyleSheet css = StructureFactory.createIncludedCssStyleSheet();
            css.setFileName(fileName);
            this.doAddCss(css);
        }
        catch (SemanticException e) {
            activityStack.rollback();
            throw e;
        }
        activityStack.commit();
    }

    private void doAddCss(IncludedCssStyleSheet css) throws SemanticException {
        if (!$assertionsDisabled && css == null) {
            throw new AssertionError();
        }
        ElementPropertyDefn propDefn = this.element.getPropertyDefn("cssStyleSheets");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        propCommand.addItem((MemberRef)new CachedMemberRef(propDefn), (Object)css);
    }

    public void dropCss(CssStyleSheet sheet) throws SemanticException {
        if (sheet == null) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans();
        String fileName = sheet.getFileName();
        try {
            this.removeIncludeCss(fileName);
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        CssRecord record = new CssRecord(this.module, this.element, sheet, false);
        this.getActivityStack().execute(record);
        this.getActivityStack().commit();
    }

    private void removeIncludeCss(String fileName) throws SemanticException {
        if (fileName == null) {
            return;
        }
        IncludedCssStyleSheet css = this.getIncludedCssStyleSheetByLocation(fileName);
        if (css == null) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.CSS_NOT_FOUND");
        }
        ElementPropertyDefn propDefn = this.element.getPropertyDefn("cssStyleSheets");
        ComplexPropertyCommand propCommand = new ComplexPropertyCommand(this.module, this.element);
        propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), css);
    }

    private CssStyleSheet getCssStyleSheetByLocation(String location) {
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List csses = sheet.getCsses();
        return CssStyleSheetAdapter.getCssStyleSheetByLocation(this.module, csses, location);
    }

    private IncludedCssStyleSheet getIncludedCssStyleSheetByLocation(String location) {
        if (location == null) {
            return null;
        }
        ICssStyleSheetOperation sheet = (ICssStyleSheetOperation)((Object)this.element);
        List csses = sheet.getCsses();
        int position = CssStyleSheetAdapter.getPositionOfCssStyleSheet(this.module, csses, location);
        if (position == -1) {
            return null;
        }
        csses = this.element.getListProperty(this.module, "cssStyleSheets");
        return (IncludedCssStyleSheet)csses.get(position);
    }

    public void reloadCss(CssStyleSheet sheet) throws SemanticException {
        CssStyleSheet newStyleSheet;
        if (sheet == null) {
            return;
        }
        String fileName = sheet.getFileName();
        try {
            newStyleSheet = this.module.loadCss(fileName);
        }
        catch (StyleSheetException styleSheetException) {
            throw new CssException(this.module, new String[]{fileName}, "Error.CSSException.BADCSSFILE");
        }
        List csses = ((ICssStyleSheetOperation)((Object)this.element)).getCsses();
        int pos = csses.indexOf(sheet);
        ActivityStack activityStack = this.getActivityStack();
        activityStack.startSilentTrans();
        CssRecord record = new CssRecord(this.module, this.element, sheet, false);
        this.getActivityStack().execute(record);
        record = new CssRecord(this.module, this.element, newStyleSheet, true, pos);
        this.getActivityStack().execute(record);
        this.doPostReloadAction(newStyleSheet);
    }

    private void doPostReloadAction(CssStyleSheet css) {
        CssReloadedEvent event = new CssReloadedEvent(this.module, css);
        this.module.broadcast(event);
        ActivityStack activityStack = this.module.getActivityStack();
        activityStack.commit();
        activityStack.flush();
        this.module.setSaveState(0);
        activityStack.sendNotifcations(new ActivityStackEvent(activityStack, 1));
    }
}

