/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.StyleRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class StyleCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.command.StyleCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StyleCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setStyle(String name) throws StyleException {
        Object retValue;
        block4: {
            name = StringUtil.trimString(name);
            if (!this.element.getDefn().hasStyle()) {
                throw new StyleException(this.element, name, "Error.StyleException.FORBIDDEN");
            }
            StyledElement obj = (StyledElement)this.element;
            ElementPropertyDefn propDefn = obj.getPropertyDefn("style");
            if (name == null && obj.getStyleName() == null) {
                return;
            }
            retValue = null;
            try {
                retValue = propDefn.validateValue(this.module, name);
            }
            catch (PropertyValueException propertyValueException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        this.doSetStyleRefValue((ElementRefValue)retValue);
    }

    public void setStyleElement(DesignElement style) throws StyleException {
        String name = null;
        if (style != null) {
            name = style.getFullName();
        }
        this.setStyle(name);
    }

    public void setStyleElement(StyleHandle parent) throws StyleException {
        if (parent == null) {
            this.setStyle(null);
            return;
        }
        this.setStyle(parent.getName());
    }

    protected void setStyleRefValue(ElementRefValue refValue) throws StyleException {
        if (refValue == null && this.element instanceof StyledElement && ((StyledElement)this.element).getStyleName() == null) {
            return;
        }
        this.doSetStyleRefValue(refValue);
    }

    private void doSetStyleRefValue(ElementRefValue newStyleValue) throws StyleException {
        if (newStyleValue != null && !newStyleValue.isResolved()) {
            throw new StyleException(this.element, newStyleValue.getName(), "Error.StyleException.NOT_FOUND");
        }
        if (newStyleValue != null && newStyleValue.isResolved() && newStyleValue.getElement() == this.element.getStyle()) {
            return;
        }
        StyledElement obj = (StyledElement)this.element;
        StyleRecord record = new StyleRecord(obj, newStyleValue);
        this.getActivityStack().execute(record);
    }
}

