/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class StyleElement
extends ReferenceableElement {
    private static final String REPORT_SELECTOR = "report";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.StyleElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StyleElement() {
    }

    public StyleElement(String theName) {
        super(theName);
    }

    protected void adjustDeliveryPath(NotificationEvent ev) {
        ev.setDeliveryPath(2);
    }

    public boolean isStyle() {
        return true;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        return this.getLocalProperty(module, prop);
    }

    public DesignElement getExtendsElement() {
        return null;
    }

    public String getExtendsName() {
        return null;
    }

    public void setExtendsElement(DesignElement base) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setExtendsName(String name) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    protected void broadcastToClients(NotificationEvent ev, Module module) {
        super.broadcastToClients(ev, module);
        ArrayList<String> selectors = new ArrayList<String>();
        if (ev instanceof NameEvent) {
            String oldName = ((NameEvent)ev).getOldName();
            String newName = ((NameEvent)ev).getNewName();
            if (MetaDataDictionary.getInstance().getPredefinedStyle(oldName) != null) {
                selectors.add(oldName);
            }
            if (MetaDataDictionary.getInstance().getPredefinedStyle(newName) != null) {
                selectors.add(newName);
            }
        } else if (MetaDataDictionary.getInstance().getPredefinedStyle(this.getName()) != null) {
            selectors.add(this.getName());
        }
        if (selectors.isEmpty()) {
            return;
        }
        DesignElement tmpContainer = this.getContainer();
        ArrayList<DesignElement> modules = new ArrayList<DesignElement>();
        if (this.getContainer() instanceof Theme) {
            Theme containerTheme = (Theme)tmpContainer;
            if (containerTheme.hasReferences()) {
                List refs = ((Theme)tmpContainer).getClientList();
                int i = 0;
                while (i < refs.size()) {
                    modules.add(((BackRef)refs.get(i)).getElement());
                    ++i;
                }
            }
        } else {
            modules.add(module);
        }
        int i = 0;
        while (i < modules.size()) {
            this.broadcastToModule((Module)modules.get(i), selectors);
            ++i;
        }
    }

    private void broadcastToModule(Module module, List selectorList) {
        if (!$assertionsDisabled && selectorList.isEmpty()) {
            throw new AssertionError();
        }
        Iterator iter = selectorList.iterator();
        while (iter.hasNext()) {
            String selectorName = (String)iter.next();
            if (REPORT_SELECTOR.equals(selectorName)) {
                StyleEvent event = null;
                event = new StyleEvent(module);
                event.setDeliveryPath(2);
                module.broadcast(event);
                continue;
            }
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 5), selectorName);
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 4), selectorName);
            if (!(module instanceof ReportDesign)) continue;
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 6), selectorName);
            this.broadcastToSelectedElementsInSlot(module, new ContainerContext((DesignElement)module, 7), selectorName);
        }
    }

    private void broadcastToSelectedElementsInSlot(Module module, ContainerContext containerInfor, String selectorName) {
        Iterator iter = containerInfor.getContents(module).iterator();
        StyleEvent event = null;
        while (iter.hasNext()) {
            ElementDefn elementDefn;
            DesignElement element = (DesignElement)iter.next();
            event = new StyleEvent(element);
            event.setDeliveryPath(2);
            String selector = this.getMatchedElementSelector(element, selectorName, module);
            if (selector != null) {
                element.broadcast(event, module);
                continue;
            }
            if (this.checkSlotSelector(element, selectorName, event, module) || !(elementDefn = (ElementDefn)element.getDefn()).isContainer()) continue;
            int i = 0;
            while (i < elementDefn.getSlotCount()) {
                this.broadcastToSelectedElementsInSlot(module, new ContainerContext(element, i), selectorName);
                ++i;
            }
            List properties = elementDefn.getContents();
            int i2 = 0;
            while (i2 < properties.size()) {
                PropertyDefn propDefn = (PropertyDefn)properties.get(i2);
                this.broadcastToSelectedElementsInSlot(module, new ContainerContext(element, propDefn.getName()), selectorName);
                ++i2;
            }
        }
    }

    private String getMatchedElementSelector(DesignElement element, String selectorName, Module module) {
        String selector = null;
        if (element instanceof ExtendedItem) {
            String tmpSelector = null;
            ExtensionElementDefn elementDefn = ((ExtendedItem)element).getExtDefn();
            if (elementDefn != null) {
                tmpSelector = elementDefn.getSelector();
            }
            if (tmpSelector != null && tmpSelector.equalsIgnoreCase(selectorName)) {
                selector = tmpSelector;
            } else {
                List tmpSelectors = ((ExtendedItem)element).getReportItemDefinedSelectors(module);
                int i = 0;
                while (i < tmpSelectors.size()) {
                    Object styleObject = tmpSelectors.get(i);
                    tmpSelector = styleObject instanceof IStyleDeclaration ? ((IStyleDeclaration)styleObject).getName() : (String)styleObject;
                    if (selectorName.equalsIgnoreCase(tmpSelector)) {
                        selector = tmpSelector;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (selector == null) {
            selector = ((ElementDefn)element.getDefn()).getSelector();
        }
        if (selector != null && selector.equalsIgnoreCase(selectorName)) {
            return selector;
        }
        return null;
    }

    private boolean checkSlotSelector(DesignElement element, String selectorName, NotificationEvent event, Module module) {
        String selector = element.getContainerInfo().getSelector();
        if (selector != null && selector.equalsIgnoreCase(selectorName)) {
            element.broadcast(event, module);
            return true;
        }
        return false;
    }
}

