/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class GroupPropSearchStrategy
extends PropertySearchStrategy {
    private static final GroupPropSearchStrategy instance = new GroupPropSearchStrategy();
    private static final Set dataBindingProps = new HashSet();

    static {
        dataBindingProps.add("groupName");
        dataBindingProps.add("keyExpr");
        dataBindingProps.add("filter");
        dataBindingProps.add("sort");
        dataBindingProps.add("intervalBase");
        dataBindingProps.add("interval");
        dataBindingProps.add("intervalRange");
        dataBindingProps.add("sortDirection");
        dataBindingProps.add("sortType");
    }

    protected GroupPropSearchStrategy() {
    }

    public static PropertySearchStrategy getInstance() {
        return instance;
    }

    protected Object getPropertyFromSelf(Module module, DesignElement element, ElementPropertyDefn prop) {
        if (!dataBindingProps.contains(prop.getName())) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        GroupElement tmpGroup = this.findCorrespondingGroupElement(module, element);
        if (tmpGroup == null) {
            return super.getPropertyFromSelf(module, element, prop);
        }
        return tmpGroup.getProperty(module, prop);
    }

    private GroupElement findCorrespondingGroupElement(Module module, DesignElement element) {
        DesignElement tmpContainer = element.getContainer();
        if (tmpContainer == null) {
            return null;
        }
        ElementRefValue refValue = (ElementRefValue)tmpContainer.getLocalProperty(module, "dataBindingRef");
        DesignElement target = null;
        while (refValue != null && refValue.isResolved()) {
            target = refValue.getElement();
            if (!(target instanceof ListingElement)) break;
            tmpContainer = target;
            refValue = (ElementRefValue)tmpContainer.getLocalProperty(module, "dataBindingRef");
        }
        if (!(target instanceof ListingElement)) {
            return null;
        }
        int index = element.getContainerInfo().indexOf(element);
        ListingElement listing = (ListingElement)target;
        List groups = listing.getGroups();
        if (groups.isEmpty() || groups.size() <= index) {
            return null;
        }
        return (GroupElement)groups.get(index);
    }

    public static Set getDataBindingPropties() {
        return Collections.unmodifiableSet(dataBindingProps);
    }
}

