/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.DesignParserHandler;
import org.eclipse.birt.report.model.parser.ModuleReader;

public final class DesignReader
extends ModuleReader {
    private static DesignReader instance = new DesignReader();

    private DesignReader() {
    }

    public static DesignReader getInstance() {
        return instance;
    }

    public ReportDesign read(DesignSession session, String fileName, InputStream inputStream, ModuleOption options) throws DesignFileException {
        URL systemId = URIUtil.getDirectory(fileName);
        DesignParserHandler handler = new DesignParserHandler(session, systemId, fileName, options);
        return (ReportDesign)this.readModule(handler, inputStream);
    }

    public ReportDesign read(DesignSession session, URL systemId, InputStream inputStream, ModuleOption options) throws DesignFileException {
        DesignParserHandler handler = new DesignParserHandler(session, systemId, null, options);
        return (ReportDesign)this.readModule(handler, inputStream);
    }

    public ReportDesign read(DesignSession session, String fileName, ModuleOption options) throws DesignFileException {
        URL systemId = URIUtil.getDirectory(fileName);
        DesignParserHandler handler = new DesignParserHandler(session, systemId, fileName, options);
        return (ReportDesign)this.readModule(handler);
    }
}

