/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser.treebuild;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ContentNode {
    protected ContentNode parent = null;
    protected List children = null;
    protected LinkedHashMap attributes = null;
    protected String name = null;
    protected boolean isCDATASection = false;
    protected String value = null;

    public ContentNode(String name) {
        this.name = name;
        this.children = new ArrayList();
        this.attributes = new LinkedHashMap();
    }

    public void addChild(ContentNode child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
        child.parent = this;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAttributes(Map attributes) {
        this.attributes.putAll(attributes);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public List getChildren() {
        if (this.children == null || this.children.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public Map getAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return this.attributes;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtil.trimString(value);
    }

    public boolean isCDATASection() {
        if ("xml-property".equalsIgnoreCase(this.name) || "method".equalsIgnoreCase(this.name)) {
            return true;
        }
        return this.isCDATASection;
    }

    public void setCDATASection(boolean isCDATASection) {
        this.isCDATASection = isCDATASection;
    }
}

