/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.AccessControl;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.FilterConditionElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.MemberValue;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.SortElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.ValueAccessControl;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;

public class ReportDesignSerializer
extends ElementVisitor {
    private ReportDesign targetDesign = null;
    private ReportDesign sourceDesign = null;
    private Stack elements = new Stack();
    private Map externalElements = new LinkedHashMap();
    private Map externalStructs = new LinkedHashMap();
    private Map cubes = new LinkedHashMap();
    private DesignElement currentNewElement = null;
    private List propertyBindings = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.ReportDesignSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ReportDesign getTarget() {
        return this.targetDesign;
    }

    public void visitReportDesign(ReportDesign obj) {
        this.sourceDesign = obj;
        this.targetDesign = this.localizeDesign(obj);
        this.visitSlots(obj, this.targetDesign, 10);
        this.localizeExternalSelectors();
        this.addExternalElements();
        this.addExternalStructures();
        this.localizeDimensionConditions();
        this.targetDesign.setProperty("propertyBindings", (Object)this.propertyBindings);
        this.release();
        this.targetDesign.getVersionManager().setVersion(this.sourceDesign.getVersionManager().getVersion());
    }

    private void release() {
        this.elements = null;
        this.externalElements = null;
        this.externalStructs = null;
        this.currentNewElement = null;
        this.cubes = null;
        this.propertyBindings = null;
    }

    public void visitDesignElement(DesignElement obj) {
        DesignElement newElement = this.localize(obj);
        ElementDefn elementDefn = (ElementDefn)obj.getDefn();
        if (elementDefn.isContainer()) {
            List properties;
            int slotCount = elementDefn.getSlotCount();
            if (slotCount > 0) {
                this.visitSlots(obj, newElement, slotCount);
            }
            if ((properties = elementDefn.getContents()).size() > 0) {
                this.visitContainerProperties(obj, newElement, properties);
            }
        }
        this.currentNewElement = newElement;
    }

    private void addExternalStructures() {
        ArrayList<EmbeddedImage> images = (ArrayList<EmbeddedImage>)this.targetDesign.getLocalProperty((Module)this.targetDesign, "images");
        if (images == null) {
            images = new ArrayList<EmbeddedImage>();
            this.targetDesign.setProperty("images", images);
        }
        Iterator embeddedImages = this.externalStructs.values().iterator();
        while (embeddedImages.hasNext()) {
            EmbeddedImage image = (EmbeddedImage)embeddedImages.next();
            this.targetDesign.rename(image);
            images.add(image);
        }
    }

    private void addExternalElements() {
        ArrayList tmpElements = new ArrayList();
        tmpElements.addAll(this.externalElements.keySet());
        ArrayList processedElements = new ArrayList();
        int index = 0;
        while (processedElements.size() < this.externalElements.size()) {
            DesignElement originalElement = (DesignElement)tmpElements.get(index++);
            this.addExternalElement(tmpElements, processedElements, originalElement);
        }
    }

    private void addExternalElement(List elements, List processedElements, DesignElement originalElement) {
        int newId;
        if (processedElements.contains(originalElement)) {
            return;
        }
        DesignElement originalContainer = originalElement.getContainer();
        if (elements.contains(originalContainer)) {
            this.addExternalElement(elements, processedElements, originalContainer);
        }
        processedElements.add(originalElement);
        DesignElement tmpElement = (DesignElement)this.externalElements.get(originalElement);
        DesignElement tmpContainer = this.getTargetContainer(originalElement, tmpElement, processedElements);
        ContainerContext context = null;
        if (tmpContainer != null) {
            context = originalElement.getContainerInfo().createContext(tmpContainer);
        }
        if (context == null && originalContainer instanceof Theme) {
            newId = 0;
            context = new ContainerContext((DesignElement)this.targetDesign, newId);
        }
        if (context == null && originalContainer instanceof Library) {
            context = originalElement.getContainerInfo();
            newId = -1;
            switch (context.getSlotID()) {
                case 0: {
                    newId = -1;
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 6: {
                    newId = 9;
                    break;
                }
                default: {
                    newId = context.getSlotID();
                }
            }
            context = new ContainerContext(tmpContainer, newId);
        }
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (context.contains(this.targetDesign, tmpElement)) {
            return;
        }
        this.addElement(this.targetDesign, context, tmpElement);
        this.targetDesign.manageId(tmpElement, true);
        this.localizePropertyBindings(originalElement, tmpElement);
    }

    private void addElement(Module module, ContainerContext context, DesignElement content) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        context.add(module, content);
        if (context.isManagedByNameSpace()) {
            module.rename(context.getElement(), content);
        }
        this.addElement2NameSpace(content);
        ContentIterator iter = new ContentIterator(module, content);
        while (iter.hasNext()) {
            DesignElement child = (DesignElement)iter.next();
            this.addElement2NameSpace(child);
        }
    }

    private void addElement2NameSpace(DesignElement element) {
        NameSpace namespace;
        if (element == null || !element.isManagedByNameSpace()) {
            return;
        }
        int ns = ((ElementDefn)element.getDefn()).getNameSpaceID();
        if (element.getName() != null && ns != -1 && (namespace = new NameExecutor(element).getNameSpace(this.targetDesign)) != null) {
            if (namespace.contains(element.getName())) {
                throw new RuntimeException("element name is not unique");
            }
            namespace.insert(element);
        }
    }

    public void visitStyle(Style obj) {
        this.visitDesignElement(obj);
    }

    public void visitTheme(Theme obj) {
    }

    public void visitReportItem(ReportItem obj) {
        this.visitStyledElement(obj);
    }

    public void visitScalarParameter(ScalarParameter obj) {
        this.visitParameter(obj);
    }

    public void visitStyledElement(StyledElement obj) {
        this.visitDesignElement(obj);
        this.localizeStyle((StyledElement)this.currentNewElement, obj);
    }

    private void localizeStyle(StyledElement target, StyledElement source) {
        HashSet notEmptyProperties = new HashSet();
        this.localizeSelfStyleProperties(target, source, notEmptyProperties);
        notEmptyProperties.clear();
    }

    private void localizeExternalSelectors() {
        if (!$assertionsDisabled && !this.elements.isEmpty()) {
            throw new AssertionError();
        }
        this.elements.push(this.targetDesign);
        Theme theme = this.sourceDesign.getTheme(this.sourceDesign);
        if (theme == null) {
            this.elements.pop();
            return;
        }
        Module tmpRoot = theme.getRoot();
        List styles = theme.getAllStyles();
        int i = 0;
        while (i < styles.size()) {
            Style tmpStyle = (Style)styles.get(i);
            this.visitExternalSelector(tmpStyle, tmpRoot);
            ++i;
        }
        this.elements.pop();
    }

    private void localizeSelfStyleProperties(StyledElement target, StyledElement source, Set notEmptyProperties) {
        StyledElement tmpElement = source;
        while (tmpElement != null) {
            Module root = tmpElement.getRoot();
            this.localizePrivateStyleProperties(target, tmpElement, root, notEmptyProperties);
            Style style = (Style)tmpElement.getStyle();
            if (style != null) {
                Module styleRoot = style.getRoot();
                if (styleRoot != this.sourceDesign) {
                    this.localizePrivateStyleProperties(target, style, styleRoot, notEmptyProperties);
                } else {
                    target.setStyleName(tmpElement.getStyleName());
                }
            }
            tmpElement = tmpElement.isVirtualElement() ? (StyledElement)tmpElement.getVirtualParent() : (StyledElement)tmpElement.getExtendsElement();
        }
    }

    private void localizePrivateStyleProperties(DesignElement target, DesignElement source, Module root, Set notEmptyProperties) {
        if (!source.hasLocalPropertyValues()) {
            return;
        }
        IElementDefn defn = source.getDefn();
        Iterator iter = source.propertyWithLocalValueIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn targetProp;
            String propName;
            ElementPropertyDefn prop = (ElementPropertyDefn)defn.getProperty((String)iter.next());
            if (prop == null || !prop.isStyleProperty() || notEmptyProperties.contains(propName = prop.getName()) || (targetProp = target.getPropertyDefn(propName)) == null) continue;
            if (target.getLocalProperty((Module)this.targetDesign, prop) != null) {
                notEmptyProperties.add(propName);
                continue;
            }
            Object value = source.getLocalProperty(root, prop);
            if (value == null) continue;
            switch (targetProp.getTypeCode()) {
                case 20: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                    break;
                }
                case 16: {
                    this.handleStructureValue(target, targetProp, value);
                    break;
                }
                default: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                }
            }
            notEmptyProperties.add(propName);
        }
    }

    public void visitMasterPage(MasterPage obj) {
        this.visitStyledElement(obj);
    }

    public void visitGroup(GroupElement obj) {
        this.visitDesignElement(obj);
    }

    public void visitRow(TableRow obj) {
        this.visitStyledElement(obj);
    }

    public void visitCell(Cell obj) {
        this.visitStyledElement(obj);
    }

    public void visitColumn(TableColumn obj) {
        this.visitStyledElement(obj);
    }

    public void visitDataSet(DataSet obj) {
        this.visitDesignElement(obj);
    }

    public void visitDataSource(DataSource obj) {
        this.visitDesignElement(obj);
    }

    public void visitTemplateParameterDefinition(TemplateParameterDefinition obj) {
        this.visitDesignElement(obj);
    }

    private void visitSlots(DesignElement obj, DesignElement newElement, int slotCount) {
        this.elements.push(newElement);
        int i = 0;
        while (i < slotCount) {
            this.visitContents(this.sourceDesign, new ContainerContext(obj, i));
            ++i;
        }
        this.elements.pop();
    }

    private void visitExternalSlots(DesignElement obj, DesignElement newElement, int slotCount) {
        this.elements.push(newElement);
        int i = 0;
        while (i < slotCount) {
            this.visitExternalContents(this.sourceDesign, new ContainerContext(obj, i));
            ++i;
        }
        this.elements.pop();
    }

    private void visitContainerProperties(DesignElement obj, DesignElement newElement, List properties) {
        this.elements.push(newElement);
        int i = 0;
        while (i < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)properties.get(i);
            this.visitContents(this.sourceDesign, new ContainerContext(obj, propDefn.getName()));
            ++i;
        }
        this.elements.pop();
    }

    private DesignElement createNewElement(DesignElement element) {
        ContainerContext sourceContainment = element.getContainerInfo();
        ContainerContext containment = null;
        DesignElement container = (DesignElement)this.elements.peek();
        String containmentProp = sourceContainment.getPropertyName();
        containment = containmentProp != null ? new ContainerContext(container, containmentProp) : new ContainerContext(container, sourceContainment.getSlotID());
        DesignElement newElement = this.newElement(element.getDefn().getName(), element.getName(), containment).getElement();
        Set externalOriginalElements = this.externalElements.keySet();
        if (externalOriginalElements.contains(element)) {
            return newElement;
        }
        if (element instanceof ReportDesign) {
            return newElement;
        }
        if (newElement instanceof GroupElement) {
            newElement.setProperty("groupName", element.getLocalProperty((Module)this.sourceDesign, "groupName"));
        }
        newElement.setID(element.getID());
        this.addElement(this.targetDesign, containment, newElement);
        if (!(newElement instanceof ContentElement)) {
            this.targetDesign.addElementID(newElement);
        }
        return newElement;
    }

    private IStructure visitExternalStruct(IStructure struct) {
        IStructure newStrcut = struct.copy();
        this.cacheMapping(struct, newStrcut);
        return newStrcut;
    }

    private DesignElement localize(DesignElement element) {
        DesignElement newElement = this.createNewElement(element);
        this.localizePropertyValues(element, newElement);
        this.localizePropertyBindings(element, newElement);
        return newElement;
    }

    private void localizePropertyBindings(DesignElement element, DesignElement newElement) {
        DesignElementHandle tmpElementHandle = element.getHandle(this.sourceDesign);
        List elementBindings = tmpElementHandle.getPropertyBindings();
        ArrayList<PropertyBinding> newList = new ArrayList<PropertyBinding>();
        long newID = newElement.getID();
        int i = 0;
        while (i < elementBindings.size()) {
            PropertyBinding propBinding = (PropertyBinding)elementBindings.get(i);
            PropertyBinding newBinding = (PropertyBinding)propBinding.copy();
            newBinding.setID(newID);
            newList.add(newBinding);
            ++i;
        }
        this.propertyBindings.addAll(newList);
    }

    private ReportDesign localizeDesign(ReportDesign source) {
        ReportDesign design;
        block3: {
            design = new ReportDesign(source.getSession());
            design.setFileName(source.getFileName());
            design.setSystemId(source.getSystemId());
            ModuleOption options = source.getOptions();
            try {
                if (options != null) {
                    design.setOptions((ModuleOption)options.copy());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.localizePropertyValues(source, design);
        this.visitCssStyleSheets(source, design);
        return design;
    }

    private void visitCssStyleSheets(ReportDesign source, ReportDesign target) {
        List sheets = source.getCsses();
        int i = 0;
        while (i < sheets.size()) {
            CssStyleSheet sheet = (CssStyleSheet)sheets.get(i);
            CssStyleSheet newSheet = this.visitCssStyleSheet(sheet);
            newSheet.setContainer(target);
            target.addCss(newSheet);
            ++i;
        }
    }

    private CssStyleSheet visitCssStyleSheet(CssStyleSheet sheet) {
        CssStyleSheet newSheet = new CssStyleSheet();
        newSheet.setFileName(sheet.getFileName());
        List styles = sheet.getStyles();
        int i = 0;
        while (i < styles.size()) {
            CssStyle style = (CssStyle)styles.get(i);
            CssStyle newStyle = this.visitCssStyle(style);
            newStyle.setCssStyleSheet(newSheet);
            newSheet.addStyle(newStyle);
            ++i;
        }
        return newSheet;
    }

    private CssStyle visitCssStyle(CssStyle style) {
        CssStyle newStyle = new CssStyle(style.getName());
        this.localizePrivateStyleProperties(newStyle, style, (Module)style.getContainer(), new HashSet());
        return newStyle;
    }

    private DesignElement visitExternalElement(DesignElement element) {
        if (element instanceof Theme) {
            return null;
        }
        ElementFactory factory = new ElementFactory(this.targetDesign);
        DesignElement newElement = factory.newElement(element.getDefn().getName(), element.getName()).getElement();
        IElementDefn elementDefn = newElement.getDefn();
        if (elementDefn.isContainer()) {
            List properties;
            int slotCount = elementDefn.getSlotCount();
            if (slotCount > 0) {
                this.visitExternalSlots(element, newElement, slotCount);
            }
            if ((properties = elementDefn.getContents()).size() > 0) {
                this.visitExternalContainerProperties(element, newElement, properties);
            }
        }
        this.localizePropertyValues(element, newElement);
        this.cacheMapping(element, newElement);
        return newElement;
    }

    private void visitExternalContainerProperties(DesignElement obj, DesignElement newElement, List properties) {
        this.elements.push(newElement);
        int i = 0;
        while (i < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)properties.get(i);
            this.visitExternalContents(this.sourceDesign, new ContainerContext(obj, propDefn.getName()));
            ++i;
        }
        this.elements.pop();
    }

    private void visitExternalContents(Module module, ContainerContext context) {
        List contents = context.getContents(module);
        Iterator iter = contents.iterator();
        DesignElement tmpContainer = (DesignElement)this.elements.peek();
        while (iter.hasNext()) {
            DesignElement tmpElement = (DesignElement)iter.next();
            DesignElement cachedExternalElement = this.getCache(tmpElement);
            if (cachedExternalElement != null) {
                ContainerContext newContext = context.createContext(tmpContainer);
                this.addElement(module, newContext, cachedExternalElement);
                continue;
            }
            this.visitExternalElement(tmpElement);
        }
    }

    private void visitExternalSelector(Style element, Module elementRoot) {
        String tmpStyleName = element.getName().toLowerCase();
        if (MetaDataDictionary.getInstance().getPredefinedStyle(tmpStyleName) == null) {
            return;
        }
        Style sourceDesignStyle = (Style)this.targetDesign.findNativeStyle(tmpStyleName);
        if (sourceDesignStyle == null) {
            ElementFactory factory = new ElementFactory(this.targetDesign);
            DesignElement newElement = factory.newElement(element.getDefn().getName(), element.getName()).getElement();
            this.localizePropertyValues(element, newElement);
            this.cacheMapping(element, newElement);
            newElement.setName(tmpStyleName);
            return;
        }
        Iterator iter1 = element.propertyWithLocalValueIterator();
        while (iter1.hasNext()) {
            String elem = (String)iter1.next();
            if (sourceDesignStyle.getLocalProperty((Module)this.targetDesign, elem) != null) continue;
            Object value = element.getLocalProperty(elementRoot, elem);
            sourceDesignStyle.setProperty(elem, value);
        }
    }

    private void localizeUserPropDefn(DesignElement element, DesignElement newElement) {
        Iterator iter = null;
        DesignElement current = element;
        if (current.isVirtualElement()) {
            return;
        }
        do {
            if (!current.hasUserProperties()) continue;
            iter = current.getLocalUserProperties().iterator();
            while (iter.hasNext()) {
                UserPropertyDefn uDefn = (UserPropertyDefn)iter.next();
                if (newElement.getLocalUserPropertyDefn(uDefn.getName()) != null) continue;
                newElement.addUserPropertyDefn((UserPropertyDefn)uDefn.copy());
            }
        } while ((current = current.getExtendsElement()) != null);
    }

    private void localizePropertyValues(DesignElement element, DesignElement newElement) {
        this.localizeUserPropDefn(element, newElement);
        Module root = element.getRoot();
        if (element instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(element, newElement, root);
        }
        Iterator iter = element.getPropertyDefns().iterator();
        block8: while (iter.hasNext()) {
            Object value;
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("extends".equals(propName) || "userProperties".equals(propName) || "theme".equals(propName) || "libraries".equals(propName) || "propertyBindings".equals(propName) || propDefn.isStyleProperty() && !(element instanceof Style) || "style".equals(propName) || (value = element.getStrategy().getPropertyFromElement(root, element, propDefn)) == null) continue;
            switch (propDefn.getTypeCode()) {
                case 15: {
                    this.handleElementRefValue(newElement, (PropertyDefn)propDefn, (ElementRefValue)value);
                    break;
                }
                case 19: {
                    this.handleStructureRefValue(newElement, propDefn, (StructRefValue)value);
                    break;
                }
                case 20: {
                    if (propDefn.getSubTypeCode() == 15) {
                        this.handleElementRefValueList(newElement, propDefn, (List)value);
                        break;
                    }
                    if (newElement.getLocalProperty(null, propDefn) != null) continue block8;
                    newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
                    break;
                }
                case 16: {
                    if (newElement instanceof Cube && "dimensionConditions".equals(propDefn.getName()) && element.getRoot() == this.sourceDesign) {
                        this.handleDimensionConditions((Cube)newElement, (Cube)element);
                        break;
                    }
                    this.handleStructureValue(newElement, propDefn, value);
                    break;
                }
                case 23: {
                    break;
                }
                case 24: {
                    this.handleContentElementValue(newElement, propDefn, value);
                    break;
                }
                default: {
                    if (newElement.getLocalProperty(null, propDefn) != null) continue block8;
                    if (propDefn.isEncryptable()) {
                        String encryption = element.getEncryptionID(propDefn);
                        newElement.setEncryptionHelper(propDefn, encryption);
                        value = ModelUtil.encryptProperty(newElement, propDefn, encryption, value);
                        newElement.setProperty(propDefn, value);
                        break;
                    }
                    newElement.setProperty(propDefn, value);
                }
            }
        }
    }

    private void handleDimensionConditions(Cube newCube, Cube cube) {
        if (newCube.getLocalProperty((Module)this.targetDesign, "dimensionConditions") != null) {
            return;
        }
        if (this.cubes.get(cube) == null) {
            this.cubes.put(newCube, cube);
        }
    }

    private void localizeDimensionConditions() {
        if (this.cubes.isEmpty()) {
            return;
        }
        Iterator iter = this.cubes.keySet().iterator();
        while (iter.hasNext()) {
            Cube newCube = (Cube)iter.next();
            Cube srcCube = (Cube)this.cubes.get(newCube);
            List dimensionConditionList = (List)srcCube.getProperty((Module)this.sourceDesign, "dimensionConditions");
            ArrayList<DimensionCondition> newValueList = new ArrayList<DimensionCondition>();
            newCube.setProperty("dimensionConditions", newValueList);
            if (dimensionConditionList == null) continue;
            int i = 0;
            while (i < dimensionConditionList.size()) {
                DimensionCondition dimensionCond = (DimensionCondition)dimensionConditionList.get(i);
                DimensionCondition newDimensionCond = (DimensionCondition)dimensionCond.copy();
                newValueList.add(newDimensionCond);
                ElementRefValue hierarchyRef = (ElementRefValue)dimensionCond.getLocalProperty((Module)this.sourceDesign, "hierarchy");
                if (hierarchyRef != null && hierarchyRef.isResolved()) {
                    DesignElement hierarchy = hierarchyRef.getElement();
                    if (!$assertionsDisabled && hierarchy == null) {
                        throw new AssertionError();
                    }
                    int hierarchyIndex = hierarchy.getIndex(this.sourceDesign);
                    DesignElement dimension = hierarchy.getContainer();
                    if (!$assertionsDisabled && dimension == null) {
                        throw new AssertionError();
                    }
                    int dimensionIndex = dimension.getIndex(this.sourceDesign);
                    DesignElement newDimension = this.getContent(this.targetDesign, newCube, "dimensions", dimensionIndex);
                    if (!$assertionsDisabled && newDimension == null) {
                        throw new AssertionError();
                    }
                    DesignElement newHierarchy = this.getContent(this.targetDesign, newDimension, "hierarchies", hierarchyIndex);
                    if (!$assertionsDisabled && newHierarchy == null) {
                        throw new AssertionError();
                    }
                    newDimensionCond.setProperty("hierarchy", (Object)new ElementRefValue(null, newHierarchy));
                    List joinConditionList = (List)dimensionCond.getProperty((Module)this.sourceDesign, "joinConditions");
                    if (joinConditionList != null && !joinConditionList.isEmpty()) {
                        List newJoinConditionList = (List)newDimensionCond.getProperty((Module)this.targetDesign, "joinConditions");
                        int j = 0;
                        while (j < joinConditionList.size()) {
                            DimensionJoinCondition joinCond = (DimensionJoinCondition)joinConditionList.get(j);
                            DimensionJoinCondition newJoinCond = (DimensionJoinCondition)newJoinConditionList.get(j);
                            ElementRefValue levelRef = (ElementRefValue)joinCond.getLocalProperty((Module)this.sourceDesign, "level");
                            if (levelRef != null && levelRef.isResolved()) {
                                DesignElement level = levelRef.getElement();
                                if (!$assertionsDisabled && level == null) {
                                    throw new AssertionError();
                                }
                                int levelIndex = level.getIndex(this.sourceDesign);
                                if (level.getContainer() == hierarchy) {
                                    DesignElement newLevel = this.getContent(this.targetDesign, newHierarchy, "levels", levelIndex);
                                    if (!$assertionsDisabled && newLevel == null) {
                                        throw new AssertionError();
                                    }
                                    newJoinCond.setProperty("level", (Object)new ElementRefValue(null, newLevel));
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private DesignElement getContent(Module module, DesignElement element, String propName, int index) {
        Object value = element.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List valueList = (List)value;
            if (index >= 0 && index < valueList.size()) {
                return (DesignElement)valueList.get(index);
            }
        } else if (value instanceof DesignElement && index == 0) {
            return (DesignElement)value;
        }
        return null;
    }

    private void handleContentElementValue(DesignElement newElement, PropertyDefn propDefn, Object value) {
        this.elements.push(newElement);
        if (propDefn.isListType()) {
            List tmplist = (List)value;
            int i = 0;
            while (i < tmplist.size()) {
                DesignElement tmpElement = (DesignElement)tmplist.get(i);
                tmpElement.apply(this);
                ++i;
            }
            this.elements.pop();
            return;
        }
        ((DesignElement)value).apply(this);
        this.elements.pop();
    }

    private void handleStructureValue(DesignElement newElement, PropertyDefn propDefn, Object valueList) {
        if (propDefn.isList() && "images".equalsIgnoreCase(propDefn.getName())) {
            ArrayList images = newElement.getListProperty(this.targetDesign, "images");
            if (images == null) {
                images = new ArrayList();
                newElement.setProperty(propDefn, images);
            }
            this.localizeEmbeddedImage((List)valueList, images);
        } else {
            newElement.setProperty(propDefn, this.createNewStructureValue(propDefn, valueList));
        }
    }

    private Object createNewStructureValue(PropertyDefn propDefn, Object value) {
        Cloneable newValue = null;
        if (propDefn.isList()) {
            List sourceValue = (List)value;
            newValue = new ArrayList();
            int i = 0;
            while (i < sourceValue.size()) {
                Structure newStruct = this.doCreateNewStructureValue((Structure)sourceValue.get(i));
                ((List)((Object)newValue)).add(newStruct);
                ++i;
            }
        } else {
            newValue = this.doCreateNewStructureValue((Structure)value);
        }
        return newValue;
    }

    private Structure doCreateNewStructureValue(Structure struct) {
        Structure newStruct = (Structure)struct.copy();
        Iterator iter = struct.getObjectDefn().propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn memberDefn = (StructPropertyDefn)iter.next();
            Object value = struct.getLocalProperty((Module)this.sourceDesign, memberDefn);
            if (value == null) continue;
            switch (memberDefn.getTypeCode()) {
                case 15: {
                    this.handleElementRefValue(newStruct, (PropertyDefn)memberDefn, (ElementRefValue)value);
                    break;
                }
                case 16: {
                    newStruct.setProperty(memberDefn, this.createNewStructureValue(memberDefn, value));
                    break;
                }
                default: {
                    newStruct.setProperty(memberDefn, ModelUtil.copyValue(memberDefn, value));
                }
            }
        }
        return newStruct;
    }

    private void handleElementRefValue(Structure structure, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (refElement != null && refElement.getRoot() != this.sourceDesign) {
            DesignElement newRefEelement = this.getCache(refElement);
            if (newRefEelement == null) {
                newRefEelement = this.visitExternalElement(refElement);
            }
            if (!$assertionsDisabled && newRefEelement == null) {
                throw new AssertionError();
            }
            structure.setProperty(propDefn, (Object)new ElementRefValue(null, newRefEelement));
        } else {
            structure.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        }
    }

    private void handleElementRefValueList(DesignElement newElement, PropertyDefn propDefn, List valueList) {
        ArrayList<ElementRefValue> values = new ArrayList<ElementRefValue>();
        int i = 0;
        while (i < valueList.size()) {
            ElementRefValue item = (ElementRefValue)valueList.get(i);
            DesignElement refElement = item.getElement();
            if (refElement != null && refElement.getRoot() != this.sourceDesign) {
                DesignElement newRefEelement = this.getCache(refElement);
                if (newRefEelement == null) {
                    newRefEelement = this.visitExternalElement(refElement);
                }
                values.add(new ElementRefValue(null, newRefEelement));
            } else {
                newElement.setProperty(propDefn, (Object)item);
            }
            ++i;
        }
        newElement.setProperty(propDefn, values);
    }

    private void handleStructureRefValue(DesignElement newElement, PropertyDefn propDefn, StructRefValue value) {
        if (!this.isLocalImage(value.getQualifiedReference())) {
            EmbeddedImage targetEmbeddedImage = (EmbeddedImage)value.getTargetStructure();
            EmbeddedImage newEmbeddedIamge = this.localizeExternalEmbeddedImage(targetEmbeddedImage);
            newElement.setProperty(propDefn, (Object)new StructRefValue(null, newEmbeddedIamge));
        } else {
            newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
        }
    }

    private void handleElementRefValue(DesignElement newElement, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (refElement != null && refElement.getRoot() != this.sourceDesign) {
            DesignElement newRefEelement = this.getCache(refElement);
            if (newRefEelement == null) {
                newRefEelement = this.visitExternalElement(refElement);
            }
            if (newRefEelement != null) {
                newElement.setProperty(propDefn, (Object)new ElementRefValue(null, newRefEelement));
            }
        } else {
            newElement.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        }
    }

    private void localizeEmbeddedImage(List sourceEmbeddedImage, List targetEmeddedImage) {
        int i = 0;
        while (i < sourceEmbeddedImage.size()) {
            EmbeddedImage sourceImage = (EmbeddedImage)sourceEmbeddedImage.get(i);
            if (!targetEmeddedImage.contains(sourceImage)) {
                EmbeddedImage newEmeddedImage = (EmbeddedImage)sourceImage.copy();
                this.localizeEmbeddedImageValues(sourceImage, newEmeddedImage);
                targetEmeddedImage.add(newEmeddedImage);
            }
            ++i;
        }
    }

    private void localizeEmbeddedImageValues(EmbeddedImage sourceEmbeddedImage, EmbeddedImage targetEmeddedImage) {
        EmbeddedImage tmpEmeddedImage = sourceEmbeddedImage;
        while (tmpEmeddedImage != null && (targetEmeddedImage.getData(null) == null || targetEmeddedImage.getType(null) == null)) {
            targetEmeddedImage.setData(tmpEmeddedImage.getData(this.sourceDesign));
            targetEmeddedImage.setType(tmpEmeddedImage.getType(this.sourceDesign));
            StructRefValue refValue = (StructRefValue)tmpEmeddedImage.getProperty((Module)this.sourceDesign, "libReference");
            if (refValue == null) break;
            tmpEmeddedImage = (EmbeddedImage)refValue.getTargetStructure();
        }
        targetEmeddedImage.setProperty("libReference", null);
    }

    private EmbeddedImage localizeExternalEmbeddedImage(EmbeddedImage sourceEmbeddedImage) {
        EmbeddedImage newEmeddedImage = (EmbeddedImage)this.getCache(sourceEmbeddedImage);
        if (newEmeddedImage != null) {
            return newEmeddedImage;
        }
        newEmeddedImage = (EmbeddedImage)this.visitExternalStruct(sourceEmbeddedImage);
        this.localizeEmbeddedImageValues(sourceEmbeddedImage, newEmeddedImage);
        return newEmeddedImage;
    }

    private void cacheMapping(DesignElement sourceElement, DesignElement targetElement) {
        this.externalElements.put(sourceElement, targetElement);
    }

    private void cacheMapping(IStructure sourceStruct, IStructure targetStruct) {
        this.externalStructs.put(sourceStruct, targetStruct);
    }

    private IStructure getCache(IStructure sourceStruct) {
        return (IStructure)this.externalStructs.get(sourceStruct);
    }

    private DesignElement getCache(DesignElement sourceElement) {
        return (DesignElement)this.externalElements.get(sourceElement);
    }

    private boolean isLocalImage(String imageName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return StructureRefUtil.findNativeStructure(this.targetDesign, defn, imageName) != null;
    }

    private DesignElement getTargetContainer(DesignElement sourceElement, DesignElement target, List processedElement) {
        DesignElement sourceContainer = sourceElement.getContainer();
        long containerId = sourceContainer.getID();
        DesignElement tmpContainer = null;
        tmpContainer = (DesignElement)this.externalElements.get(sourceContainer);
        if (tmpContainer == null) {
            tmpContainer = this.targetDesign.getElementByID(containerId);
        }
        if (tmpContainer == null) {
            return null;
        }
        if (sourceContainer.getElementName().equalsIgnoreCase(tmpContainer.getElementName())) {
            return tmpContainer;
        }
        if (sourceContainer instanceof Module && tmpContainer == this.targetDesign) {
            return tmpContainer;
        }
        if (sourceContainer instanceof Theme) {
            return this.targetDesign;
        }
        return tmpContainer;
    }

    public void visitMemberValue(MemberValue obj) {
        this.visitDesignElement(obj);
    }

    public void visitFilterConditionElement(FilterConditionElement obj) {
        this.visitDesignElement(obj);
    }

    public void visitSortElement(SortElement obj) {
        this.visitDesignElement(obj);
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ModelUtil.newElement(this.targetDesign, elementTypeName, name);
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public DesignElementHandle newElement(String elementTypeName, String name, ContainerContext targetContext) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ReportDesignSerializer.newElement(this.targetDesign, targetContext, elementTypeName, name);
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public static DesignElement newElement(Module module, ContainerContext targetContainment, String elementTypeName, String name) {
        DesignElement element = ModelUtil.newElement(elementTypeName, name);
        if (targetContainment.isManagedByNameSpace()) {
            module.rename(targetContainment.getElement(), element);
        }
        return element;
    }

    private DesignElementHandle newExtensionElement(String elementTypeName, String name) {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(elementTypeName);
        if (extDefn == null) {
            return null;
        }
        String extensionPoint = extDefn.getExtensionPoint();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(extensionPoint)) {
            return this.newExtendedItem(name, elementTypeName);
        }
        return null;
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        try {
            return this.newExtendedItem(name, extensionName, null);
        }
        catch (ExtendsException extendsException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private ExtendedItemHandle newExtendedItem(String name, String extensionName, ExtendedItemHandle parent) throws ExtendsException {
        ExtendedItemHandle handle;
        block6: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null && !$assertionsDisabled && ((ExtendedItem)parent.getElement()).getExtDefn() != extDefn) {
                throw new AssertionError();
            }
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            element.setProperty("extensionName", (Object)extensionName);
            if (parent != null) {
                element.getHandle(this.targetDesign).setExtends(parent);
            }
            this.targetDesign.makeUniqueName(element);
            handle = element.handle(this.targetDesign);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException extendedElementException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return handle;
    }

    public void visitAccessControl(AccessControl obj) {
        this.visitDesignElement(obj);
    }

    public void visitValueAccessControl(ValueAccessControl obj) {
        this.visitDesignElement(obj);
    }
}

