/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.aggregation.AggregationInfo;
import org.eclipse.birt.data.engine.aggregation.BuiltInAggregationFactory;
import org.eclipse.birt.data.engine.aggregation.ParameterInfo;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.aggregation.IAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IAggregationInfo;
import org.eclipse.birt.data.engine.core.DataException;

public class AggregationFactory
implements IAggregationFactory {
    private static final String MODEL_RANK = "rank";
    private static final String MODEL_PERCENT_SUM = "percent-sum";
    private static final String MODEL_QUARTILE = "quartile";
    private static final String MODEL_PERCENTILE = "percentile";
    private static final String MODEL_PERCENT_RANK = "percent-rank";
    private static final String MODEL_IS_BOTTOM_N_PERCENT = "is-bottom-n-percent";
    private static final String MODEL_IS_TOP_N_PERCENT = "is-top-n-percent";
    private static final String MODEL_IS_BOTTOM_N = "is-bottom-n";
    private static final String MODEL_IS_TOP_N = "is-top-n";
    private static final String MODEL_RUNNING_COUNT = "running-count";
    private static final String MODEL_COUNT_DISTINCT = "count-distinct";
    private static final String MODEL_RUNNING_NPV = "running-npv";
    private static final String MODEL_NPV = "npv";
    private static final String MODEL_MIRR = "mirr";
    private static final String MODEL_IRR = "irr";
    private static final String MODEL_RUNNING_SUM = "running-sum";
    private static final String MODEL_VARIANCE = "variance";
    private static final String MODEL_MEDIAN = "median";
    private static final String MODEL_MOVING_AVE = "moving-ave";
    private static final String MODEL_MODE = "mode";
    private static final String MODEL_LAST = "last";
    private static final String MODEL_FIRST = "first";
    private static final String MODEL_STDDEV = "stddev";
    private static final String MODEL_WEIGHTED_AVG = "weighted-avg";
    private static final String MODEL_AVERAGE = "average";
    private static final String MODEL_MAX = "max";
    private static final String MODEL_MIN = "min";
    private static final String MODEL_COUNT = "count";
    private static final String MODEL_SUM = "sum";
    private static final String ATTRIBUTE_AGGREGATION_CLASS = "aggregationClass";
    private static final String ATTRIBUTE_AGGREGATION_NAME = "name";
    private static final String EXTENSION_POINT = "org.eclipse.birt.data.aggregation";
    private static final String ELEMENT_AGGREGATIONS = "Aggregations";
    private static final String ELEMENT_AGGREGATION = "Aggregation";
    private static final String ELEMENT_UIINFO = "UIInfo";
    private static final String ATTRIBUTE_PARAMETER_META_INFO = "parameterMetaInfo";
    private static final String ATTRIBUTE_TEXT_DATA = "textData";
    private static IAggregationFactory instance;
    private static Map aggregations;
    private static Map aggrAdapterMap;
    private static Map aggrInfoMap;
    private static String[] xTabAggrNames;
    private static String[] measureAggrNames;
    private static List tabularAggrNames;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.AggregationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = null;
        aggregations = null;
        aggrAdapterMap = null;
        aggrInfoMap = null;
        xTabAggrNames = new String[]{"SUM", "AVE", "MAX", "MIN", "FIRST", "LAST", "COUNT", "COUNTDISTINCT"};
        measureAggrNames = new String[]{"SUM", "MAX", "MIN", "FIRST", "LAST", "COUNT", "COUNTDISTINCT"};
        tabularAggrNames = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IAggregationFactory getInstance() throws DataException {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.aggregation.AggregationFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new AggregationFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void destroyInstance() {
        instance = null;
        aggregations = null;
        aggrAdapterMap = null;
        aggrInfoMap = null;
    }

    private AggregationFactory() throws DataException {
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        aggregations = new HashMap();
        aggrAdapterMap = new HashMap();
        aggrInfoMap = new HashMap();
        AggregationFactory.populateAggrAdapterMap();
        this.populateBuiltInAggregations();
        this.populateExtendedAggregations();
        this.populateAggrInfo();
    }

    private void populateAggrInfo() {
        AggregationInfo aggrInfo = new AggregationInfo("SUM", "total.func.sum");
        aggrInfoMap.put("SUM", aggrInfo);
        tabularAggrNames.add("SUM");
        aggrInfo = new AggregationInfo("RUNNINGSUM", "total.func.runningSum");
        aggrInfoMap.put("RUNNINGSUM", aggrInfo);
        tabularAggrNames.add("RUNNINGSUM");
        aggrInfo = new AggregationInfo("COUNT", "total.func.count");
        aggrInfo.setNeedDataField(false);
        aggrInfoMap.put("COUNT", aggrInfo);
        tabularAggrNames.add("COUNT");
        aggrInfo = new AggregationInfo("RUNNINGCOUNT", "total.func.runningCount");
        aggrInfo.setNeedDataField(false);
        aggrInfoMap.put("RUNNINGCOUNT", aggrInfo);
        tabularAggrNames.add("RUNNINGCOUNT");
        aggrInfo = new AggregationInfo("COUNTDISTINCT", "total.func.countDistinct");
        aggrInfo.setNeedDataField(true);
        aggrInfoMap.put("COUNTDISTINCT", aggrInfo);
        tabularAggrNames.add("COUNTDISTINCT");
        aggrInfo = new AggregationInfo("MAX", "total.func.max");
        aggrInfoMap.put("MAX", aggrInfo);
        tabularAggrNames.add("MAX");
        aggrInfo = new AggregationInfo("MIN", "total.func.min");
        aggrInfoMap.put("MIN", aggrInfo);
        tabularAggrNames.add("MIN");
        aggrInfo = new AggregationInfo("AVE", "total.func.ave");
        aggrInfoMap.put("AVE", aggrInfo);
        tabularAggrNames.add("AVE");
        aggrInfo = new AggregationInfo("WEIGHTEDAVE", "total.func.weightedAve");
        ParameterInfo paramInfo = new ParameterInfo("weight", "total.param.weightedAve.weight");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("WEIGHTEDAVE", aggrInfo);
        tabularAggrNames.add("WEIGHTEDAVE");
        aggrInfo = new AggregationInfo("MOVINGAVE", "total.func.movingAve");
        paramInfo = new ParameterInfo("window", "total.param.movingAve.window");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("MOVINGAVE", aggrInfo);
        tabularAggrNames.add("MOVINGAVE");
        aggrInfo = new AggregationInfo("MEDIAN", "total.func.median");
        aggrInfoMap.put("MEDIAN", aggrInfo);
        tabularAggrNames.add("MEDIAN");
        aggrInfo = new AggregationInfo("MODE", "total.func.mode");
        aggrInfoMap.put("MODE", aggrInfo);
        tabularAggrNames.add("MODE");
        aggrInfo = new AggregationInfo("STDDEV", "total.func.stdDev");
        aggrInfoMap.put("STDDEV", aggrInfo);
        tabularAggrNames.add("STDDEV");
        aggrInfo = new AggregationInfo("VARIANCE", "total.func.variance");
        aggrInfoMap.put("VARIANCE", aggrInfo);
        tabularAggrNames.add("VARIANCE");
        aggrInfo = new AggregationInfo("FIRST", "total.func.first");
        aggrInfoMap.put("FIRST", aggrInfo);
        tabularAggrNames.add("FIRST");
        aggrInfo = new AggregationInfo("LAST", "total.func.last");
        aggrInfoMap.put("LAST", aggrInfo);
        tabularAggrNames.add("LAST");
        aggrInfo = new AggregationInfo("RANK", "total.func.rank");
        paramInfo = new ParameterInfo("ascending", "total.param.rank.ascending");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("RANK", aggrInfo);
        tabularAggrNames.add("RANK");
        aggrInfo = new AggregationInfo("PERCENTRANK", "total.func.percentRank");
        aggrInfoMap.put("PERCENTRANK", aggrInfo);
        tabularAggrNames.add("PERCENTRANK");
        aggrInfo = new AggregationInfo("PERCENTILE", "total.func.percentile");
        paramInfo = new ParameterInfo("pct", "total.param.percentile.pct");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("PERCENTILE", aggrInfo);
        tabularAggrNames.add("PERCENTILE");
        aggrInfo = new AggregationInfo("QUARTILE", "total.func.quartile");
        paramInfo = new ParameterInfo("QUARTILE", "total.param.quartile.quart");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("QUARTILE", aggrInfo);
        tabularAggrNames.add("QUARTILE");
        aggrInfo = new AggregationInfo("PERCENTSUM", "total.func.percentSum");
        aggrInfoMap.put("PERCENTSUM", aggrInfo);
        tabularAggrNames.add("PERCENTSUM");
        aggrInfo = new AggregationInfo("ISTOPN", "total.func.isTopN");
        paramInfo = new ParameterInfo("ISTOPN", "total.param.isTopN.n");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("ISTOPN", aggrInfo);
        tabularAggrNames.add("ISTOPN");
        aggrInfo = new AggregationInfo("ISTOPNPERCENT", "total.func.isTopNPercent");
        paramInfo = new ParameterInfo("ISTOPNPERCENT", "total.param.isTopNPercent.pct");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("ISTOPNPERCENT", aggrInfo);
        tabularAggrNames.add("ISTOPNPERCENT");
        aggrInfo = new AggregationInfo("ISBOTTOMN", "total.func.isBottomN");
        paramInfo = new ParameterInfo("ISBOTTOMN", "total.param.isBottomN.n");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("ISBOTTOMN", aggrInfo);
        tabularAggrNames.add("ISBOTTOMN");
        aggrInfo = new AggregationInfo("ISBOTTOMNPERCENT", "total.func.isBottomNPercent");
        paramInfo = new ParameterInfo("ISBOTTOMNPERCENT", "total.param.isBottomNPercent.pct");
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("ISBOTTOMNPERCENT", aggrInfo);
        aggrInfo = new AggregationInfo("IRR", "total.func.irr");
        paramInfo = new ParameterInfo("startingGuess", "total.param.irr.rate");
        paramInfo.setOptional(true);
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("IRR", aggrInfo);
        tabularAggrNames.add("IRR");
        aggrInfo = new AggregationInfo("MIRR", "total.func.mirr");
        paramInfo = new ParameterInfo("financeRate", "total.param.mirr.financeRate");
        paramInfo.setOptional(true);
        aggrInfo.addParameter(paramInfo);
        paramInfo = new ParameterInfo("reinvestmentRate", "total.param.mirr.reinvestmentRate");
        paramInfo.setOptional(true);
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("MIRR", aggrInfo);
        tabularAggrNames.add("MIRR");
        aggrInfo = new AggregationInfo("NPV", "total.func.npv");
        paramInfo = new ParameterInfo("rate", "total.param.npv.rate");
        paramInfo.setOptional(true);
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("NPV", aggrInfo);
        tabularAggrNames.add("NPV");
        aggrInfo = new AggregationInfo("RUNNINGNPV", "total.func.runningnpv");
        paramInfo = new ParameterInfo("rate", "total.param.runningnpv.rate");
        paramInfo.setOptional(true);
        aggrInfo.addParameter(paramInfo);
        aggrInfoMap.put("RUNNINGNPV", aggrInfo);
        tabularAggrNames.add("RUNNINGNPV");
    }

    private static void populateAggrAdapterMap() {
        aggrAdapterMap.put(MODEL_SUM, "SUM");
        aggrAdapterMap.put(MODEL_COUNT, "COUNT");
        aggrAdapterMap.put(MODEL_MIN, "MIN");
        aggrAdapterMap.put(MODEL_MAX, "MAX");
        aggrAdapterMap.put(MODEL_AVERAGE, "AVE");
        aggrAdapterMap.put(MODEL_WEIGHTED_AVG, "WEIGHTEDAVE");
        aggrAdapterMap.put(MODEL_STDDEV, "STDDEV");
        aggrAdapterMap.put(MODEL_FIRST, "FIRST");
        aggrAdapterMap.put(MODEL_LAST, "LAST");
        aggrAdapterMap.put(MODEL_MODE, "MODE");
        aggrAdapterMap.put(MODEL_MOVING_AVE, "MOVINGAVE");
        aggrAdapterMap.put(MODEL_MEDIAN, "MEDIAN");
        aggrAdapterMap.put(MODEL_VARIANCE, "VARIANCE");
        aggrAdapterMap.put(MODEL_RUNNING_SUM, "RUNNINGSUM");
        aggrAdapterMap.put(MODEL_IRR, "IRR");
        aggrAdapterMap.put(MODEL_MIRR, "MIRR");
        aggrAdapterMap.put(MODEL_NPV, "NPV");
        aggrAdapterMap.put(MODEL_RUNNING_NPV, "RUNNINGNPV");
        aggrAdapterMap.put(MODEL_COUNT_DISTINCT, "COUNTDISTINCT");
        aggrAdapterMap.put(MODEL_RUNNING_COUNT, "RUNNINGCOUNT");
        aggrAdapterMap.put(MODEL_IS_TOP_N, "ISTOPN");
        aggrAdapterMap.put(MODEL_IS_BOTTOM_N, "ISBOTTOMN");
        aggrAdapterMap.put(MODEL_IS_TOP_N_PERCENT, "ISTOPNPERCENT");
        aggrAdapterMap.put(MODEL_IS_BOTTOM_N_PERCENT, "ISBOTTOMNPERCENT");
        aggrAdapterMap.put(MODEL_PERCENT_RANK, "PERCENTRANK");
        aggrAdapterMap.put(MODEL_PERCENTILE, "PERCENTILE");
        aggrAdapterMap.put(MODEL_QUARTILE, "QUARTILE");
        aggrAdapterMap.put(MODEL_PERCENT_SUM, "PERCENTSUM");
        aggrAdapterMap.put(MODEL_RANK, "RANK");
    }

    private void populateBuiltInAggregations() {
        String[] builtInAggrNames = BuiltInAggregationFactory.getInstance().getAggregationNames();
        int i = 0;
        while (i < builtInAggrNames.length) {
            aggregations.put(builtInAggrNames[i], BuiltInAggregationFactory.getInstance().getAggregation(builtInAggrNames[i]));
            ++i;
        }
    }

    private void populateExtendedAggregations() throws DataException {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    if (configElems[i].getName().equals(ELEMENT_AGGREGATIONS)) {
                        IConfigurationElement[] subElems = configElems[i].getChildren(ELEMENT_AGGREGATION);
                        int j = 0;
                        while (j < subElems.length) {
                            String name = subElems[j].getAttribute(ATTRIBUTE_AGGREGATION_NAME).toUpperCase().trim();
                            try {
                                IAggregation aggrFunc = (IAggregation)subElems[j].createExecutableExtension(ATTRIBUTE_AGGREGATION_CLASS);
                                this.populateExtendedAggrInfo(name, aggrFunc, subElems[j]);
                                if (aggregations.put(name, aggrFunc) != null) {
                                    throw new DataException("date.engine.DuplicateAggregationName", name);
                                }
                            }
                            catch (FrameworkException frameworkException) {}
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
    }

    private void populateExtendedAggrInfo(String name, IAggregation aggrFunc, IConfigurationElement elem) {
        IConfigurationElement[] uiInfo = elem.getChildren(ELEMENT_UIINFO);
        if (!($assertionsDisabled || uiInfo != null && uiInfo.length == 1)) {
            throw new AssertionError();
        }
        String paramInfo = uiInfo[0].getAttribute(ATTRIBUTE_PARAMETER_META_INFO);
        String textInfo = uiInfo[0].getAttribute(ATTRIBUTE_TEXT_DATA);
        AggregationInfo aggrInfo = new AggregationInfo(name);
        aggrInfo.setDisplayName(textInfo);
        String[] paramInfos = paramInfo.split(",");
        boolean[] paramFlags = aggrFunc.getParameterDefn();
        if (paramInfos != null && paramInfos.length > 0) {
            int k = 0;
            while (k < paramInfos.length) {
                String s = paramInfos[k].trim();
                int index = s.indexOf(32);
                String paramName = null;
                paramName = index > 0 ? s.substring(index + 1).trim() : paramInfos[k];
                if (k + 1 >= paramFlags.length) break;
                ParameterInfo argInfo = new ParameterInfo(paramName);
                argInfo.setOptional(!paramFlags[k + 1]);
                aggrInfo.addParameter(argInfo);
                ++k;
            }
        }
        aggrInfoMap.put(name, aggrInfo);
        tabularAggrNames.add(name);
    }

    public List getAggrInfoList(int type) {
        switch (type) {
            case 0: {
                return this.getResult(tabularAggrNames.toArray());
            }
            case 1: {
                return this.getResult(xTabAggrNames);
            }
            case 2: {
                return this.getResult(measureAggrNames);
            }
        }
        return new ArrayList();
    }

    private List getResult(Object[] names) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < names.length) {
            Object aggrInfo = aggrInfoMap.get(names[i]);
            if (aggrInfo != null) {
                list.add(aggrInfo);
            }
            ++i;
        }
        return list;
    }

    public IAggregation getAggregation(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        IAggregation aggr = (IAggregation)aggregations.get(name.toUpperCase());
        if (aggr == null) {
            String buildInAggrName = (String)aggrAdapterMap.get(name);
            aggr = (IAggregation)aggregations.get(buildInAggrName);
        }
        return aggr;
    }

    public IAggregationInfo getAggrInfo(String aggrName) {
        return (IAggregationInfo)aggrInfoMap.get(aggrName);
    }
}

