/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SizeOfUtil {
    private static final int INTEGER_SIZE = 16;
    private static final int DOUBLE_SIZE = 16;
    private static int BIGDECIMAL_SIZE = 80;
    private static final int DATE_SIZE = 24;
    private static final int TIME_SIZE = 24;
    private static final int SQL_DATE_SIZE = 24;
    private static int TIMESTAMP_SIZE = 24;
    private int fieldCount = 0;
    private boolean[] isfixedSize = null;
    private int[] fieldSize = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        if (System.getProperty("java.version").startsWith("1.5")) {
            BIGDECIMAL_SIZE = 96;
            TIMESTAMP_SIZE = 32;
        }
    }

    public SizeOfUtil(IResultClass resultClass) throws DataException {
        this.fieldCount = resultClass.getFieldCount();
        this.isfixedSize = new boolean[resultClass.getFieldCount()];
        this.fieldSize = new int[resultClass.getFieldCount()];
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            if (SizeOfUtil.isFixedSizeClass(resultClass.getFieldValueClass(i))) {
                this.fieldSize[i - 1] = SizeOfUtil.sizeOf(resultClass.getFieldValueClass(i));
                this.isfixedSize[i - 1] = true;
            } else {
                this.isfixedSize[i - 1] = false;
            }
            ++i;
        }
    }

    private static boolean isFixedSizeClass(Class objectClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!objectClass.equals(clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!objectClass.equals(clazz2)) {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!objectClass.equals(clazz3)) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.util.Date");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!objectClass.equals(clazz4)) {
                        Class<?> clazz5 = class$4;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$4 = Class.forName("java.sql.Date");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!objectClass.equals(clazz5)) {
                            Class<?> clazz6 = class$5;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = class$5 = Class.forName("java.sql.Time");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!objectClass.equals(clazz6)) {
                                Class<?> clazz7 = class$6;
                                if (clazz7 == null) {
                                    try {
                                        clazz7 = class$6 = Class.forName("java.sql.Timestamp");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (!objectClass.equals(clazz7)) {
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private static int sizeOf(Class objectClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz)) {
            return 16;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz2)) {
            return 16;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz3)) {
            return BIGDECIMAL_SIZE;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz4)) {
            return 24;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz5)) {
            return 24;
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz6)) {
            return TIMESTAMP_SIZE;
        }
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz7)) {
            return 24;
        }
        return 0;
    }

    public int sizeOf(IResultObject resultObject) throws DataException {
        int returnValue = 0;
        int i = 1;
        while (i <= this.fieldCount) {
            if (!this.isfixedSize[i - 1]) {
                if (resultObject.getFieldValue(i) != null) {
                    returnValue += SizeOfUtil.sizeOf(resultObject.getFieldValue(i).getClass(), resultObject.getFieldValue(i));
                }
            } else if (resultObject.getFieldValue(i) != null) {
                returnValue += this.fieldSize[i - 1];
            }
            ++i;
        }
        int fieldsSize = 16 + (4 + this.fieldCount * 4 - 1) / 8 * 8;
        return returnValue += 16 + (4 + fieldsSize - 1) / 8 * 8;
    }

    private static int sizeOf(Class objectClass, Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz)) {
            int strLen = ((String)object).length();
            return 40 + (strLen + 1) / 4 * 8;
        }
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (objectClass.equals(clazz2)) {
            int byteLen = ((byte[])object).length;
            return 16 + (4 + byteLen - 1) / 8 * 8;
        }
        return SizeOfUtil.sizeOf(objectClass);
    }
}

