/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;

public class DataSetCacheUtil {
    public static int getCacheOption(DataEngineContext context, Map appContext) {
        Object option;
        int cacheOption = context.getCacheOption();
        if (appContext != null) {
            int rowLimit;
            Object option2 = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE);
            if (option2 != null && (rowLimit = DataSetCacheUtil.getIntValueFromString(option2)) > 0) {
                return 3;
            }
            option2 = appContext.get(DataEngine.DATA_SET_CACHE_ROW_LIMIT);
            if (option2 != null) {
                rowLimit = DataSetCacheUtil.getIntValueFromString(option2);
                if (rowLimit == 0) {
                    return 2;
                }
                return 3;
            }
        }
        int realCacheOption = cacheOption == 3 ? 3 : (cacheOption == 2 ? 2 : (appContext != null ? ((option = appContext.get(DataEngine.DATASET_CACHE_OPTION)) != null && option.toString().equals("true") ? 1 : 2) : 2));
        return realCacheOption;
    }

    private static int getIntValueFromString(Object option) {
        return Integer.valueOf(option.toString());
    }

    public static int getCacheCount(DataEngineContext context, Map appContext) {
        if (appContext != null) {
            int rowLimit;
            Object option = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE);
            if (option != null && (rowLimit = DataSetCacheUtil.getIntValueFromString(option)) > 0) {
                return rowLimit;
            }
            option = appContext.get(DataEngine.DATA_SET_CACHE_ROW_LIMIT);
            if (option != null) {
                return DataSetCacheUtil.getIntValueFromString(option);
            }
        }
        return context.getCacheCount();
    }

    public static int getCacheMode(Map appContext) {
        int rowLimit;
        Object option;
        if (appContext != null && (option = appContext.get(DataEngine.MEMORY_DATA_SET_CACHE)) != null && (rowLimit = DataSetCacheUtil.getIntValueFromString(option)) > 0) {
            return 1;
        }
        return 2;
    }

    public static URL getCacheConfig(Map appContext) {
        if (appContext != null) {
            Object configValue = appContext.get(DataEngine.INCREMENTAL_CACHE_CONFIG);
            URL url = null;
            if (configValue instanceof URL) {
                url = (URL)configValue;
            } else if (configValue instanceof String) {
                String configPath = configValue.toString();
                try {
                    url = new URL(configPath);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        url = new URL("file", "/", configPath);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        return null;
                    }
                }
            }
            return url;
        }
        return null;
    }

    public static boolean needsToCache(IBaseDataSetDesign dataSetDesign, int cacheOption, int alwaysCacheRowCount) {
        if (dataSetDesign == null) {
            return false;
        }
        if (dataSetDesign instanceof IIncreCacheDataSetDesign) {
            return true;
        }
        if (cacheOption == 2) {
            return false;
        }
        return !(cacheOption == 3 ? alwaysCacheRowCount == 0 : dataSetDesign.getCacheRowCount() == 0);
    }

    public static int getCacheRowCount(int cacheOption, int alwaysCacheRowCount, int cacheRowCount) {
        if (cacheOption == 3) {
            if (alwaysCacheRowCount <= 0) {
                return Integer.MAX_VALUE;
            }
            return alwaysCacheRowCount;
        }
        if (cacheOption == 2) {
            return Integer.MAX_VALUE;
        }
        if (cacheRowCount == -1) {
            return Integer.MAX_VALUE;
        }
        return cacheRowCount;
    }
}

