/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.impl.OdaDataSetRuntime;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IQuery;

public class PreparedIncreCacheDSQuery
extends PreparedOdaDSQuery
implements IPreparedQuery {
    static /* synthetic */ Class class$0;

    PreparedIncreCacheDSQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext);
    }

    protected QueryExecutor newExecutor() {
        String tmpdir = this.dataEngine.getContext().getTmpdir();
        IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)this.dataSetDesign;
        String cacheDir = CacheUtil.createIncrementalTempDir(tmpdir, icDataSetDesign.getConfigFileUrl().toString(), icDataSetDesign.getName());
        logger.log(Level.INFO, "Create incremental cache directory: " + cacheDir);
        this.getDataSetCacheManager().registerCacheDir(icDataSetDesign, cacheDir);
        return new IncreCacheDSQueryExecutor(cacheDir);
    }

    public class IncreCacheDSQueryExecutor
    extends PreparedOdaDSQuery.OdaDSQueryExecutor {
        private String cacheDir;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.PreparedIncreCacheDSQuery");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public IncreCacheDSQueryExecutor(String cacheDir) {
            super(PreparedIncreCacheDSQuery.this);
            this.cacheDir = cacheDir;
        }

        protected IQuery createOdiQuery() throws DataException {
            OdaDataSetRuntime extDataSet = (OdaDataSetRuntime)this.dataSet;
            if (!$assertionsDisabled && extDataSet == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.odiDataSource == null) {
                throw new AssertionError();
            }
            IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)PreparedIncreCacheDSQuery.this.dataSetDesign;
            String queryText = null;
            try {
                long lasttime = CacheUtil.getLastTimestamp(this.cacheDir);
                queryText = icDataSetDesign.getQueryForUpdate(lasttime);
            }
            catch (DataException dataException) {
                File dataFile = new File(this.cacheDir, "data.data");
                if (dataFile.exists()) {
                    dataFile.delete();
                    logger.log(Level.WARNING, "Incremental cache data file was deleted! path: " + dataFile.getAbsolutePath());
                }
                queryText = icDataSetDesign.getQueryText();
            }
            String dataSetType = extDataSet.getExtensionID();
            logger.log(Level.INFO, "Execute SQL: " + queryText);
            this.odiQuery = this.odiDataSource.newQuery(dataSetType, queryText);
            return this.odiQuery;
        }
    }
}

