/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.AggregationFactory;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.AggrInfo;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVSubQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ServiceForQueryResults
implements IServiceForQueryResults {
    private DataEngineContext context;
    private IPreparedQueryService queryService;
    private IQueryExecutor queryExecutor;
    private PreparedDataSourceQuery reportQuery;
    private IBaseQueryDefinition queryDefn;
    private ExprManager exprManager;
    private Scriptable scope;
    private int nestedLevel;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ServiceForQueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ServiceForQueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public ServiceForQueryResults(DataEngineContext context, Scriptable scope, int nestedLevel, PreparedDataSourceQuery reportQuery, IPreparedQueryService query, QueryExecutor queryExecutor, IBaseQueryDefinition queryDefn, ExprManager exprManager) {
        Object[] params = new Object[]{context, scope, new Integer(nestedLevel), reportQuery, query, queryExecutor, queryDefn, exprManager};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ServiceForQueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "ServiceForQueryResults", params);
        if (!($assertionsDisabled || reportQuery != null && queryExecutor != null)) {
            throw new AssertionError();
        }
        this.context = context;
        this.scope = scope;
        this.nestedLevel = nestedLevel;
        this.reportQuery = reportQuery;
        this.queryService = query;
        this.queryExecutor = queryExecutor;
        this.queryDefn = queryDefn;
        this.exprManager = exprManager;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ServiceForQueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "ServiceForQueryResults");
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public IBaseQueryDefinition getQueryDefn() {
        return this.queryDefn;
    }

    public IPreparedQuery getPreparedQuery() {
        return this.reportQuery;
    }

    public int getGroupLevel() {
        if (this.queryService instanceof PreparedSubquery) {
            PreparedSubquery subQuery = (PreparedSubquery)this.queryService;
            return subQuery.getGroupLevel();
        }
        if (this.queryService instanceof PreparedIVSubQuery) {
            PreparedIVSubQuery subQuery = (PreparedIVSubQuery)this.queryService;
            return subQuery.getGroupLevel();
        }
        return 0;
    }

    public DataSetRuntime getDataSetRuntime() {
        return this.queryExecutor.getDataSet();
    }

    public DataSetRuntime[] getDataSetRuntimes(int count) {
        if (!$assertionsDisabled && count < 0) {
            throw new AssertionError();
        }
        DataSetRuntime[] dsRuns = new DataSetRuntime[count];
        if (count > 1) {
            DataSetRuntime[] innerDsRuns = null;
            IQueryExecutor executor = this.queryExecutor;
            innerDsRuns = executor.getNestedDataSets(count - 1);
            int i = 0;
            while (i < count - 1) {
                dsRuns[i] = innerDsRuns[i];
                ++i;
            }
        }
        dsRuns[count - 1] = this.queryExecutor.getDataSet();
        return dsRuns;
    }

    public IResultMetaData getResultMetaData() throws DataException {
        return this.queryExecutor.getResultMetaData();
    }

    public IResultIterator executeQuery() throws DataException {
        this.queryExecutor.execute(new EventHandler());
        return this.queryExecutor.getOdiResultSet();
    }

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        return this.queryService.execSubquery(iterator, subQueryName, subScope);
    }

    public void close() {
        if (this.queryExecutor != null) {
            this.queryExecutor.close();
            this.queryExecutor = null;
        }
    }

    public void validateQuery() throws DataException {
        if (this.getPreparedQuery() instanceof PreparedIVQuery) {
            return;
        }
        this.exprManager.validateColumnBinding();
        this.validateFilters();
        this.validateSorts();
    }

    public IBaseExpression getBindingExpr(String exprName) throws DataException {
        return this.exprManager.getExpr(exprName);
    }

    public IScriptExpression getAutoBindingExpr(String exprName) {
        return this.exprManager.getAutoBindingExpr(exprName);
    }

    public List getAllBindingExprs() {
        return this.exprManager.getBindingExprs();
    }

    public Map getAllAutoBindingExprs() {
        return this.exprManager.getAutoBindingExprMap();
    }

    public void initAutoBinding() throws DataException {
        if (!this.needAutoBinding()) {
            return;
        }
        Context cx = Context.enter();
        IResultMetaData metaData = this.getResultMetaData();
        int columnCount = metaData.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int colIndex = i + 1;
            try {
                String colName = metaData.getColumnAlias(colIndex);
                if (colName == null) {
                    colName = metaData.getColumnName(colIndex);
                }
                ScriptExpression baseExpr = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)colName), metaData.getColumnType(colIndex));
                CompiledExpression compiledExpr = ExpressionCompilerUtil.compile(baseExpr.getText(), cx);
                baseExpr.setHandle(compiledExpr);
                this.exprManager.addAutoBindingExpr(colName, baseExpr);
            }
            catch (BirtException birtException) {}
            ++i;
        }
        Context.exit();
    }

    private boolean needAutoBinding() {
        if (this.queryDefn instanceof IQueryDefinition) {
            return ((IQueryDefinition)this.queryDefn).needAutoBinding();
        }
        return false;
    }

    private void validateFilters() throws DataException {
        int i = 0;
        while (i < this.queryDefn.getFilters().size()) {
            IFilterDefinition filter = (IFilterDefinition)this.queryDefn.getFilters().get(i);
            if (this.hasRowNumRefExpr(filter.getExpression())) {
                throw new DataException("data.engine.filterExprContainRowNum");
            }
            ++i;
        }
    }

    private void validateSorts() throws DataException {
        int i = 0;
        while (i < this.queryDefn.getSorts().size()) {
            ISortDefinition sort = (ISortDefinition)this.queryDefn.getSorts().get(i);
            if (this.hasRowNumRefExpr(sort.getExpression())) {
                throw new DataException("data.engine.sortExprContainRowNum");
            }
            ++i;
        }
    }

    private boolean hasRowNumRefExpr(IBaseExpression expr) throws DataException {
        if (expr instanceof IScriptExpression) {
            return this.hasRowNumRefExpr((IScriptExpression)expr);
        }
        if (expr instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)expr;
            return this.hasRowNumRefExpr(ce.getExpression()) || this.hasRowNumRefExpr(ce.getOperand1()) || this.hasRowNumRefExpr(ce.getOperand2());
        }
        return false;
    }

    private boolean hasRowNumRefExpr(IScriptExpression expr) throws DataException {
        block5: {
            block4: {
                try {
                    if (expr != null && expr.getText() != null) break block4;
                    return false;
                }
                catch (BirtException e) {
                    throw new DataException(e.getLocalizedMessage());
                }
            }
            if (!expr.getText().matches(".*\\Qrow.__rownum\\E.*")) break block5;
            return true;
        }
        return this.findRowNumReferenceInBindings(ExpressionUtil.extractColumnExpressions((String)expr.getText()));
    }

    private boolean findRowNumReferenceInBindings(List bindingNames) throws DataException {
        int i = 0;
        while (i < bindingNames.size()) {
            IBinding binding = (IBinding)this.queryDefn.getBindings().get(((IColumnBinding)bindingNames.get(i)).getResultSetColumnName());
            if (binding == null) {
                return false;
            }
            IBaseExpression expr = binding.getExpression();
            if (this.hasRowNumRefExpr(expr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class EventHandler
    implements IEventHandler {
        private JSResultSetRow jsResultSetRow;
        private IExecutorHelper helper;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.ServiceForQueryResults");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private EventHandler() {
        }

        public void handleEndOfDataSetProcess(IResultIterator resultIterator) {
            this.jsResultSetRow = new JSResultSetRow(resultIterator, ServiceForQueryResults.this.exprManager, ServiceForQueryResults.this.queryExecutor.getQueryScope(), this.helper);
            ServiceForQueryResults.this.getDataSetRuntime().setJSResultSetRow(this.jsResultSetRow);
        }

        public Object getValue(IResultObject rsObject, int index, String name) throws DataException {
            if (this.jsResultSetRow == null) {
                return rsObject.getFieldValue(index);
            }
            return this.jsResultSetRow.getValue(rsObject, index, name);
        }

        public boolean isRowID(int index, String name) throws DataException {
            IBaseExpression baseExpr = ServiceForQueryResults.this.exprManager.getExpr(name);
            if (baseExpr instanceof IScriptExpression) {
                String exprText = ((IScriptExpression)baseExpr).getText();
                if (exprText == null) {
                    return false;
                }
                return exprText.trim().equalsIgnoreCase("dataSetRow[0]") || exprText.trim().equalsIgnoreCase("dataSetRow._rowPosition");
            }
            return false;
        }

        public IBinding getBinding(String name) throws DataException {
            if (name == null) {
                return null;
            }
            return ServiceForQueryResults.this.exprManager.getBinding(name);
        }

        public IExecutorHelper getExecutorHelper() {
            return this.helper;
        }

        public void setExecutorHelper(IExecutorHelper helper) {
            this.helper = helper;
        }

        public Map getColumnBindings() throws DataException {
            HashMap<String, IBinding> result = new HashMap<String, IBinding>();
            List groupBindingColumns = ServiceForQueryResults.this.exprManager.getBindingExprs();
            int i = 0;
            while (i < groupBindingColumns.size()) {
                GroupBindingColumn gbc = (GroupBindingColumn)groupBindingColumns.get(i);
                Iterator it = gbc.getColumnNames().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    result.put(name, gbc.getBinding(name));
                }
                ++i;
            }
            return result;
        }

        public Map getAllColumnBindings() {
            return this.getColumnBindings(ServiceForQueryResults.this.queryDefn);
        }

        private Map getColumnBindings(IBaseQueryDefinition defn) {
            HashMap result = new HashMap();
            Iterator temp = defn.getBindings().keySet().iterator();
            while (temp.hasNext()) {
                Object key = temp.next();
                result.put(key, defn.getBindings().get(key));
            }
            result.putAll(this.populateGroupColumnBindings(defn.getGroups().iterator()));
            result.putAll(this.populateSubQueryColumnBindings(defn.getSubqueries().iterator()));
            return result;
        }

        private Map populateGroupColumnBindings(Iterator groups) {
            HashMap result = new HashMap();
            while (groups.hasNext()) {
                IGroupDefinition gd = (IGroupDefinition)groups.next();
                result.putAll(this.populateSubQueryColumnBindings(gd.getSubqueries().iterator()));
            }
            return result;
        }

        private Map populateSubQueryColumnBindings(Iterator subs) {
            HashMap result = new HashMap();
            while (subs.hasNext()) {
                IBaseQueryDefinition defn1 = (IBaseQueryDefinition)subs.next();
                result.putAll(this.getColumnBindings(defn1));
            }
            return result;
        }

        public Map getAppContext() {
            return ServiceForQueryResults.this.queryExecutor.getAppContext();
        }

        public List getAggrDefinitions() throws DataException {
            List result = this.populateAggrDefinitions();
            this.sort(result);
            return result;
        }

        private List populateAggrDefinitions() throws DataException {
            ArrayList arrayList;
            try {
                ArrayList result = new ArrayList();
                Context cx = Context.enter();
                ExpressionCompiler compiler = new ExpressionCompiler();
                compiler.setDataSetMode(false);
                List groupBindingColumns = ServiceForQueryResults.this.exprManager.getBindingExprs();
                int i = 0;
                while (i < groupBindingColumns.size()) {
                    GroupBindingColumn gbc = (GroupBindingColumn)groupBindingColumns.get(i);
                    Iterator it = gbc.getColumnNames().iterator();
                    while (it.hasNext()) {
                        String name = it.next().toString();
                        this.populateOneAggrDefinition(result, cx, compiler, gbc, name);
                    }
                    ++i;
                }
                arrayList = result;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return arrayList;
        }

        private void populateOneAggrDefinition(List result, Context cx, ExpressionCompiler compiler, GroupBindingColumn gbc, String name) throws DataException {
            IBinding binding = gbc.getBinding(name);
            if (this.isAggregationBinding(binding)) {
                List argument = binding.getArguments();
                IAggregation aggrFunction = AggregationFactory.getInstance().getAggregation(binding.getAggrFunction());
                IBaseExpression[] compiledArgu = this.populateAggregationArgument(cx, compiler, binding, argument, aggrFunction);
                compiler.compile(binding.getFilter(), cx);
                AggrInfo aggrDefn = new AggrInfo(name, gbc.getGroupLevel(), aggrFunction, compiledArgu, binding.getFilter());
                result.add(aggrDefn);
            }
        }

        private boolean isAggregationBinding(IBinding binding) throws DataException {
            return binding.getAggrFunction() != null;
        }

        private IBaseExpression[] populateAggregationArgument(Context cx, ExpressionCompiler compiler, IBinding binding, List argument, IAggregation aggrFunction) throws DataException {
            int offset = 0;
            if (aggrFunction.getParameterDefn().length > 0) {
                offset = 1;
            }
            IBaseExpression[] compiledArgu = new IBaseExpression[argument.size() + offset];
            if (offset > 0) {
                compiledArgu[0] = binding.getExpression();
                compiler.compile(compiledArgu[0], cx);
            }
            int j = offset;
            while (j < argument.size() + offset) {
                IScriptExpression scriptExpr = (IScriptExpression)argument.get(j - offset);
                compiler.compile(scriptExpr, cx);
                compiledArgu[j] = scriptExpr;
                ++j;
            }
            return compiledArgu;
        }

        private void sort(List aggrDefns) throws DataException {
            try {
                Map nameMap = this.populateBindingNameMap(aggrDefns);
                HashMap aggrRefMap = new HashMap();
                HashMap<String, Integer> aggrRefGroupLevelMap = new HashMap<String, Integer>();
                int i = 0;
                while (i < aggrDefns.size()) {
                    IAggrInfo aggrDefn = (IAggrInfo)aggrDefns.get(i);
                    ArrayList<IBaseExpression> exprs = new ArrayList<IBaseExpression>();
                    int x = 0;
                    while (x < aggrDefn.getArgument().length) {
                        exprs.add(aggrDefn.getArgument()[x]);
                        ++x;
                    }
                    if (aggrDefn.getFilter() != null) {
                        exprs.add(aggrDefn.getFilter());
                    }
                    HashSet aggrRefs = new HashSet();
                    HashSet aggrRefList = new HashSet();
                    boolean use0AggrLevel = this.popAggrRefFromExprs(aggrRefList, exprs, nameMap);
                    if (aggrRefList.size() > 0) {
                        aggrRefs.addAll(aggrRefList);
                    }
                    int groupLevel = 0;
                    int groupLevelInAggr = this.getGroupLevel(aggrRefs);
                    if (!use0AggrLevel) {
                        groupLevel = groupLevelInAggr;
                    }
                    aggrRefMap.put(aggrDefn.getName(), aggrRefs);
                    aggrRefGroupLevelMap.put(aggrDefn.getName(), new Integer(groupLevel));
                    ++i;
                }
                this.popualteCalcuateRound(aggrDefns, nameMap, aggrRefMap, aggrRefGroupLevelMap);
                this.sortAggrDefnsAccordingToCalLvl(aggrDefns);
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private int getGroupLevel(Set aggrRefs) throws DataException {
            Iterator it = aggrRefs.iterator();
            int groupLevel = -1;
            while (it.hasNext()) {
                IAggrInfo aggr = (IAggrInfo)it.next();
                if (groupLevel == -1) {
                    groupLevel = aggr.getGroupLevel();
                }
                if (groupLevel == aggr.getGroupLevel()) continue;
                throw new DataException("data.engine.WrongNumAggrArgs", aggr.getName());
            }
            return groupLevel;
        }

        private void sortAggrDefnsAccordingToCalLvl(List aggrDefns) {
            Collections.sort(aggrDefns, new Comparator(this){
                final /* synthetic */ EventHandler this$1;
                {
                    this.this$1 = eventHandler;
                }

                public int compare(Object o1, Object o2) {
                    int round2;
                    if (!EventHandler.$assertionsDisabled && !(o1 instanceof IAggrInfo)) {
                        throw new AssertionError();
                    }
                    if (!EventHandler.$assertionsDisabled && !(o2 instanceof IAggrInfo)) {
                        throw new AssertionError();
                    }
                    int round1 = ((IAggrInfo)o1).getRound();
                    if (round1 == (round2 = ((IAggrInfo)o2).getRound())) {
                        return 0;
                    }
                    if (round1 > round2) {
                        return 1;
                    }
                    return -1;
                }
            });
        }

        private void popualteCalcuateRound(List aggrDefns, Map nameMap, Map aggrRefMap, Map aggrRefGroupLevelMap) {
            ArrayList aggrDefnsCopy = new ArrayList();
            aggrDefnsCopy.addAll(aggrDefns);
            int calculateRound = -1;
            while (aggrDefnsCopy.size() > 0) {
                ++calculateRound;
                ArrayList<IAggrInfo> removedNames = new ArrayList<IAggrInfo>();
                Iterator<Object> it = aggrRefMap.keySet().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    IAggrInfo defn = (IAggrInfo)nameMap.get(name);
                    Set aggrRefList = (Set)aggrRefMap.get(name);
                    if (aggrRefList.size() != 0) continue;
                    defn.setRound(calculateRound);
                    defn.setCalculateLevel((Integer)aggrRefGroupLevelMap.get(name));
                    aggrDefnsCopy.remove(defn);
                    removedNames.add(defn);
                }
                int i = 0;
                while (i < removedNames.size()) {
                    aggrRefMap.remove(((IAggrInfo)removedNames.get(i)).getName());
                    ++i;
                }
                it = aggrRefMap.values().iterator();
                while (it.hasNext()) {
                    Set temp = (Set)it.next();
                    temp.removeAll(removedNames);
                }
            }
        }

        private Map populateBindingNameMap(List aggrDefns) {
            HashMap<String, IAggrInfo> nameMap = new HashMap<String, IAggrInfo>();
            int i = 0;
            while (i < aggrDefns.size()) {
                IAggrInfo aggrDefn = (IAggrInfo)aggrDefns.get(i);
                nameMap.put(aggrDefn.getName(), aggrDefn);
                ++i;
            }
            return nameMap;
        }

        private boolean hasDataSetRowReference(IScriptExpression expr) throws BirtException {
            return !ExpressionUtil.extractColumnExpressions((String)expr.getText(), (boolean)false).isEmpty();
        }

        private boolean popAggrRefFromExprs(Set aggrReferences, List exprs, Map aggrMap) throws DataException {
            boolean[] result = new boolean[exprs.size()];
            int i = 0;
            while (i < exprs.size()) {
                result[i] = this.popAggrRefFromBaseExpr(aggrReferences, (IBaseExpression)exprs.get(i), aggrMap);
                ++i;
            }
            boolean base = false;
            int i2 = 0;
            while (i2 < result.length) {
                if (!this.isConstantExpr((IBaseExpression)exprs.get(i2))) {
                    base = result[i2];
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < result.length) {
                if (!this.isConstantExpr((IBaseExpression)exprs.get(i2)) && result[i2] != base) {
                    throw new DataException("data.engine.AggrParamGroupLevelInconsistent");
                }
                ++i2;
            }
            return result.length == 0 ? false : base;
        }

        private boolean popAggrRefFromBaseExpr(Set aggrReferences, IBaseExpression expr, Map aggrMap) throws DataException {
            try {
                boolean result = false;
                if (expr instanceof IScriptExpression) {
                    result = this.popAggrRefFromScriptExpr(aggrReferences, (IScriptExpression)expr, aggrMap);
                } else if (expr instanceof IConditionalExpression) {
                    IConditionalExpression ce = (IConditionalExpression)expr;
                    result = this.popAggrRefFromScriptExpr(aggrReferences, ce.getExpression(), aggrMap) || this.popAggrRefFromBaseExpr(aggrReferences, ce.getOperand1(), aggrMap) || this.popAggrRefFromBaseExpr(aggrReferences, ce.getOperand2(), aggrMap);
                } else if (expr instanceof IExpressionCollection) {
                    IExpressionCollection ce = (IExpressionCollection)expr;
                    Object[] exprs = ce.getExpressions().toArray();
                    int i = 0;
                    while (i < exprs.length) {
                        if (this.popAggrRefFromBaseExpr(aggrReferences, (IBaseExpression)exprs[i], aggrMap)) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                return result;
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private boolean popAggrRefFromScriptExpr(Set aggrReferences, IScriptExpression expr, Map aggrMap) throws DataException {
            try {
                List usedRowReferences = ExpressionUtil.extractColumnExpressions((String)expr.getText());
                boolean result = this.hasDataSetRowReference(expr);
                int i = 0;
                while (i < usedRowReferences.size()) {
                    Object o = aggrMap.get(((IColumnBinding)usedRowReferences.get(i)).getResultSetColumnName());
                    if (o != null) {
                        aggrReferences.add(o);
                    } else {
                        result = result || this.popAggrRefFromBaseExpr(aggrReferences, this.getBinding(((IColumnBinding)usedRowReferences.get(i)).getResultSetColumnName()).getExpression(), aggrMap);
                    }
                    ++i;
                }
                return result;
            }
            catch (BirtException be) {
                throw DataException.wrap(be);
            }
        }

        private boolean isConstantExpr(IBaseExpression expr) throws DataException {
            if (!(expr instanceof IScriptExpression)) {
                return false;
            }
            try {
                return ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)expr).getText()).isEmpty() && !this.hasDataSetRowReference((IScriptExpression)expr);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

