/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.aggregation;

import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.aggregation.AggrExprInfo;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSAggrValueObject
extends ScriptableObject {
    private int aggrCount;
    private List aggrExprInfoList;
    private IResultIterator odiResult;
    private List[] aggrValues;
    private static final long serialVersionUID = 1L;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    JSAggrValueObject(List aggrExprInfoList, IResultIterator odiResult, List[] aggrValues) {
        Object[] params = new Object[]{aggrExprInfoList, odiResult, aggrValues};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "JSAggrValueObject", params);
        this.aggrExprInfoList = aggrExprInfoList;
        this.odiResult = odiResult;
        this.aggrValues = aggrValues;
        this.aggrCount = aggrExprInfoList.size();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "JSAggrValueObject");
    }

    public String getClassName() {
        return "_RESERVED_AGGR_VALUE";
    }

    public boolean has(int index, Scriptable start) {
        return index > 0 && index < this.aggrCount;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this.aggrCount) {
            return null;
        }
        try {
            return this.getAggregateValue(index);
        }
        catch (DataException e) {
            throw Context.reportRuntimeError((String)e.getLocalizedMessage());
        }
    }

    private Object getAggregateValue(int aggrIndex) throws DataException {
        AggrExprInfo aggrInfo = this.getAggrInfo(aggrIndex);
        if (this.odiResult.getRowCount() == 0) {
            if (aggrInfo.aggregation.getName().equalsIgnoreCase("COUNT") || aggrInfo.aggregation.getName().equalsIgnoreCase("COUNTDISTINCT")) {
                return new Integer(0);
            }
            return null;
        }
        int groupIndex = aggrInfo.aggregation.getType() == 0 ? (aggrInfo.groupLevel == 0 ? 0 : this.odiResult.getCurrentGroupIndex(aggrInfo.groupLevel)) : this.odiResult.getCurrentResultIndex();
        return this.aggrValues[aggrIndex].get(groupIndex);
    }

    private AggrExprInfo getAggrInfo(int i) {
        return (AggrExprInfo)this.aggrExprInfoList.get(i);
    }

    int getAggrCount() {
        return this.aggrExprInfoList.size();
    }

    public List getAggregateValues(int i) {
        if (i < this.aggrCount) {
            return this.aggrValues[i];
        }
        return null;
    }
}

