/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator2;

public class QueryResults
implements IQueryResults {
    private DataEngineContext context;
    private String queryResultID;
    private String baseQueryResultID;
    private IResultIterator resultIterator;
    private IResultMetaData resultMetaData;
    private String subQueryName;
    private int currParentIndex;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.document.QueryResults");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public QueryResults(DataEngineContext context, String queryResultID) {
        this(context, null, queryResultID, null, null, -1);
    }

    QueryResults(DataEngineContext context, String baseResultID, String queryResultID, IResultMetaData resultMetaData, String subQueryName, int currParentIndex) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryResultID == null) {
            throw new AssertionError();
        }
        if (subQueryName != null && !$assertionsDisabled && resultMetaData == null) {
            throw new AssertionError();
        }
        this.context = context;
        this.queryResultID = queryResultID;
        this.baseQueryResultID = baseResultID;
        this.resultMetaData = resultMetaData;
        this.subQueryName = subQueryName;
        this.currParentIndex = currParentIndex;
    }

    public IPreparedQuery getPreparedQuery() {
        return null;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        if (this.resultMetaData == null) {
            this.resultMetaData = this.getRDLoad(this.subQueryName, this.queryResultID).loadResultMetaData();
        }
        return this.resultMetaData;
    }

    public IResultIterator getResultIterator() throws BirtException {
        if (this.resultIterator == null) {
            ISubqueryDefinition subQuery;
            IBaseQueryDefinition queryDefn;
            this.resultIterator = this.subQueryName == null ? ((queryDefn = this.getRDLoad(null, this.queryResultID).loadQueryDefn(0, 2)).usesDetails() ? new ResultIterator(this.context, this, this.queryResultID) : new ResultIterator2(this.context, this, this.queryResultID, queryDefn.getGroups().size())) : ((subQuery = this.getRDLoad(null, this.baseQueryResultID).loadSubQueryDefn(0, 2, this.subQueryName)).usesDetails() ? new ResultIterator(this.context, this, this.queryResultID, this.subQueryName, this.currParentIndex) : new ResultIterator2(this.context, this, this.queryResultID, this.subQueryName, this.currParentIndex, subQuery.getGroups().size()));
        }
        return this.resultIterator;
    }

    private RDLoad getRDLoad(String subQueryName, String queryResultID) throws DataException {
        String baseID = QueryResultIDUtil.get1PartID(queryResultID);
        if (baseID == null) {
            baseID = queryResultID;
        }
        RDLoad rdLoad = RDUtil.newLoad(this.context, new QueryResultInfo(baseID, subQueryName, this.currParentIndex));
        return rdLoad;
    }

    public void close() throws BirtException {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
    }

    public String getID() {
        return this.queryResultID;
    }
}

