/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultSet
implements IDataSetPopulator {
    private int rowIndex;
    private int rowCount;
    private RAInputStream inputStream;
    private BufferedInputStream bis;
    private DataInputStream dis;
    private IResultClass rsMetaData;
    private int colCount;
    private IResultObject currentObject;
    private RAInputStream dataSetRowLensStream;
    private DataInputStream disRowLensStream;
    private long initPos;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DataSetResultSet(RAInputStream inputStream, RAInputStream lensStream, IResultClass rsMetaData, int version) {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMetaData == null) {
            throw new AssertionError();
        }
        this.inputStream = inputStream;
        this.rowIndex = -1;
        this.dataSetRowLensStream = lensStream;
        if (lensStream != null) {
            this.disRowLensStream = new DataInputStream((InputStream)this.dataSetRowLensStream);
        }
        try {
            this.initPos = this.inputStream.getOffset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.rsMetaData = rsMetaData;
        this.colCount = rsMetaData.getFieldCount();
    }

    public IResultObject next() throws DataException {
        this.initLoad();
        if (this.rowIndex < this.rowCount - 1) {
            try {
                ++this.rowIndex;
                this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount);
                return this.currentObject;
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
            }
        }
        return null;
    }

    public IResultObject getResultObject() {
        return this.currentObject;
    }

    public int getCurrentIndex() {
        return this.rowIndex;
    }

    public void skipTo(int index) throws DataException, IOException {
        if (this.rowIndex == index) {
            return;
        }
        this.initLoad();
        if (this.rowIndex < this.rowCount && this.dataSetRowLensStream != null) {
            this.dataSetRowLensStream.seek((long)(index * 8));
            long position = IOUtil.readLong((DataInputStream)this.disRowLensStream);
            this.rowIndex = index;
            this.inputStream.seek(position + this.initPos);
            this.dis = new DataInputStream((InputStream)this.inputStream);
            this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount);
            return;
        }
    }

    private void initLoad() throws DataException {
        if (this.dis == null) {
            this.bis = new BufferedInputStream((InputStream)this.inputStream);
            try {
                this.dis = new DataInputStream(this.bis);
                this.rowCount = IOUtil.readInt((InputStream)this.dis);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "result data");
            }
        }
    }

    public IResultClass getResultClass() {
        return this.rsMetaData;
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.bis.close();
            }
        }
        catch (IOException iOException) {}
    }
}

