/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DummyEventHandler;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprGroupDataResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class ExprTotalDataResultSet
implements IExprDataResultSet {
    private ResultSetCache initRsCache;
    private ResultSetCache currRsCache;
    private IResultClass resultClass;
    private int[] groupRowIndex;
    private int rowCount;
    private SortSpec sortSpec;
    private int rowIndex;
    private int[] endIndexInGroup;
    private int[] rowCountInGroup;
    private int groupIndex;
    private DataEngineSession session;

    public ExprTotalDataResultSet(ResultSetCache rsCache, IResultClass resultClass, SortSpec sortSpec, int[] groupRowIndex, int count, DataEngineSession session) {
        this.initRsCache = rsCache;
        this.sortSpec = sortSpec;
        this.resultClass = resultClass;
        this.groupRowIndex = groupRowIndex;
        this.rowCount = count;
        this.session = session;
        this.prepare();
    }

    private void prepare() {
        int groupCount = this.groupRowIndex.length / 2;
        this.endIndexInGroup = new int[groupCount];
        this.rowCountInGroup = new int[groupCount];
        int i = 0;
        while (i < groupCount) {
            int endIndex;
            int startIndex = this.groupRowIndex[2 * i];
            this.endIndexInGroup[i] = endIndex = this.groupRowIndex[2 * i + 1];
            this.rowCountInGroup[i] = endIndex - startIndex;
            ++i;
        }
    }

    public IResultClass getResultClass() {
        return this.resultClass;
    }

    public IResultObject next() throws DataException {
        return this.fetch();
    }

    public IResultObject fetch() throws DataException {
        if (this.rowIndex == this.rowCount) {
            if (this.currRsCache != null) {
                this.currRsCache.close();
                this.currRsCache = null;
            }
            return null;
        }
        if (this.rowIndex == this.endIndexInGroup[this.groupIndex]) {
            ++this.groupIndex;
            this.currRsCache.close();
            this.currRsCache = null;
        }
        if (this.currRsCache == null) {
            ExprGroupDataResultSet groupExprResultSet = new ExprGroupDataResultSet(this.initRsCache, this.resultClass, this.rowCountInGroup[this.groupIndex]);
            this.currRsCache = new SmartCache(new CacheRequest(0, null, this.sortSpec, new DummyEventHandler()), new OdiAdapter(groupExprResultSet), this.resultClass, this.session);
        }
        ++this.rowIndex;
        IResultObject ro = this.currRsCache.fetch();
        return ro;
    }

    public int getCount() throws DataException {
        return this.rowCount;
    }

    public int getRealCount() throws DataException {
        return this.rowCount;
    }

    public void close() {
        if (this.initRsCache != null) {
            this.initRsCache.close();
        }
        if (this.currRsCache != null) {
            this.currRsCache.close();
        }
    }
}

