/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;

public class ColumnHint {
    private String m_name;
    private int m_position;
    private Class m_dataType;
    private int m_nativeDataType = 0;
    private String m_alias;
    private static final int UNKNOWN_NATIVE_TYPE = 0;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ColumnHint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.ColumnHint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    public ColumnHint(String columnName) {
        String methodName = "ColumnHint";
        sm_logger.entering(sm_className, methodName, columnName);
        if (columnName == null || columnName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnNameCannotBeEmptyOrNull");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = columnName;
        sm_logger.exiting(sm_className, methodName, this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        String methodName = "setPosition";
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnPositionIsOneBased");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "Invalid column position {0}.", new Integer(position));
            }
            throw ex;
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        if (!$assertionsDisabled && dataType != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (dataType != clazz) {
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (dataType != clazz2) {
                    Class<?> clazz3 = class$3;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$3 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (dataType != clazz3) {
                        Class<?> clazz4 = class$4;
                        if (clazz4 == null) {
                            try {
                                clazz4 = class$4 = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (dataType != clazz4) {
                            Class<?> clazz5 = class$5;
                            if (clazz5 == null) {
                                try {
                                    clazz5 = class$5 = Class.forName("java.util.Date");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (dataType != clazz5) {
                                Class<?> clazz6 = class$6;
                                if (clazz6 == null) {
                                    try {
                                        clazz6 = class$6 = Class.forName("java.sql.Date");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (dataType != clazz6) {
                                    Class<?> clazz7 = class$7;
                                    if (clazz7 == null) {
                                        try {
                                            clazz7 = class$7 = Class.forName("java.sql.Time");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (dataType != clazz7) {
                                        Class<?> clazz8 = class$8;
                                        if (clazz8 == null) {
                                            try {
                                                clazz8 = class$8 = Class.forName("java.sql.Timestamp");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (dataType != clazz8) {
                                            Class<?> clazz9 = class$9;
                                            if (clazz9 == null) {
                                                try {
                                                    clazz9 = class$9 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (dataType != clazz9) {
                                                Class<?> clazz10 = class$10;
                                                if (clazz10 == null) {
                                                    try {
                                                        clazz10 = class$10 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (dataType != clazz10) {
                                                    Class<?> clazz11 = class$11;
                                                    if (clazz11 == null) {
                                                        try {
                                                            clazz11 = class$11 = Class.forName("java.lang.Boolean");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (dataType != clazz11) {
                                                        throw new AssertionError();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setNativeDataType(int typeCode) {
        this.m_nativeDataType = typeCode;
    }

    public int getNativeDataType() {
        return this.m_nativeDataType;
    }

    public void setAlias(String alias) {
        String methodName = "setAlias";
        if (alias != null && alias.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnAliasCannotBeEmpty");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "The alias is empty; must be either null or non-empty value.");
            }
            throw ex;
        }
        this.m_alias = alias;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public Class getEffectiveDataType(String odaDataSourceId, String dataSetType) {
        Class effectiveType;
        if (this.getNativeDataType() != 0 && (effectiveType = DataTypeUtil.toTypeClass(DataTypeUtil.toOdaType(this.getNativeDataType(), odaDataSourceId, dataSetType))) != null) {
            return effectiveType;
        }
        return this.getDataType();
    }
}

