/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public final class DataTypeUtil {
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz.getName();
        sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    private DataTypeUtil() {
    }

    public static Class toTypeClass(int odaDataType) {
        Class fieldClass = null;
        try {
            fieldClass = org.eclipse.birt.core.data.DataTypeUtil.toOdiTypeClass((int)odaDataType);
        }
        catch (BirtException birtException) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.UnrecognizedOdaType", new Object[]{new Integer(odaDataType)});
            sm_logger.logp(Level.SEVERE, sm_className, "toTypeClass", "Invalid ODA data type: {0}", new Integer(odaDataType));
            throw new IllegalArgumentException(localizedMessage);
        }
        if (odaDataType == 2004) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            fieldClass = clazz;
        } else if (odaDataType == 2005) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            fieldClass = clazz;
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "toTypeClass", "Converted from ODA data type {0} to Java data type class {1}.", new Object[]{new Integer(odaDataType), fieldClass});
        }
        return fieldClass;
    }

    public static int toOdaType(Class javaClass) {
        int odaType = 1;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.datatools.connectivity.oda.IBlob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (javaClass == clazz) {
            odaType = 2004;
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.datatools.connectivity.oda.IClob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            odaType = javaClass == clazz2 ? 2005 : org.eclipse.birt.core.data.DataTypeUtil.toOdaDataType((Class)javaClass);
        }
        if (sm_logger.isLoggable(Level.FINEST)) {
            sm_logger.logp(Level.FINEST, sm_className, "toOdaType", "Converted from Java data type class {0} to ODA data type {1}.", new Object[]{javaClass, new Integer(odaType)});
        }
        return odaType;
    }

    public static int toOdaType(int nativeTypeCode, String odaDataSourceId, String dataSetType) {
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            return 0;
        }
        return ManifestExplorer.getInstance().getDefaultOdaDataTypeCode(nativeTypeCode, odaDataSourceId, dataSetType);
    }
}

