/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

class Driver {
    private String m_dataSourceDriverId;
    private ExtensionManifest m_driverConfig;
    private IDriver m_driverHelper;
    private static final String sm_className;
    private static final String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.odaconsumer.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sm_className = clazz2.getName();
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }

    Driver(String dataSourceElementId) {
        sm_logger.entering(sm_className, "Driver", dataSourceElementId);
        this.m_dataSourceDriverId = dataSourceElementId;
        sm_logger.exiting(sm_className, "Driver", this);
    }

    ExtensionManifest getExtensionConfig() throws DataException {
        ExtensionManifest driverManifest = this.getDriverExtensionConfig();
        if (!$assertionsDisabled && driverManifest == null) {
            throw new AssertionError();
        }
        return driverManifest;
    }

    ExtensionManifest getDriverExtensionConfig() throws DataException {
        if (this.m_driverConfig != null) {
            return this.m_driverConfig;
        }
        this.findDataSourceExtensionConfig();
        if (!$assertionsDisabled && this.m_driverConfig == null) {
            throw new AssertionError();
        }
        return this.m_driverConfig;
    }

    IDriver getDriverHelper() throws DataException {
        if (this.m_driverHelper != null) {
            return this.m_driverHelper;
        }
        try {
            this.m_driverHelper = new OdaDriver(this.getExtensionConfig());
            return this.m_driverHelper;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDriverHelper", "Cannot get ODA data source driver helper.", ex);
            throw new DataException("odaconsumer.OdaInitEntryNotFound", (Throwable)ex, new Object[]{this.m_dataSourceDriverId});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, "getDriverHelper", "Cannot get ODA data source driver factory.", ex);
            throw new DataException("odaconsumer.OdaInitEntryNotFound", (Throwable)ex, new Object[]{this.m_dataSourceDriverId});
        }
    }

    private void findDataSourceExtensionConfig() throws DataException {
        this.m_driverConfig = null;
        this.m_driverConfig = this.doGetDriverManifest(this.m_dataSourceDriverId, true, true);
    }

    private ExtensionManifest doGetDriverManifest(String dataSourceDriverId, boolean useDtpExtPoint, boolean throwsIfNotFound) throws DataException {
        ManifestExplorer explorer = ManifestExplorer.getInstance();
        try {
            if (useDtpExtPoint) {
                return explorer.getExtensionManifest(dataSourceDriverId);
            }
            if (throwsIfNotFound) {
                throw new IllegalArgumentException(dataSourceDriverId);
            }
            return null;
        }
        catch (Exception ex) {
            if (useDtpExtPoint && ex instanceof IllegalArgumentException && !throwsIfNotFound) {
                return null;
            }
            return this.throwConfigException("doGetDriverManifest", dataSourceDriverId, ex);
        }
    }

    private ExtensionManifest throwConfigException(String methodName, String dataSourceDriverId, Throwable cause) throws DataException {
        sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot process data source extension configuration.", cause);
        throw new DataException("odaconsumer.CannotProcessDriverConfig", cause, new Object[]{dataSourceDriverId});
    }
}

