/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.DimensionAccessor;
import org.eclipse.birt.data.engine.olap.cursor.DimensionNavigator;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

class DimensionCursorImpl
extends AbstractCursorSupport
implements DimensionCursor {
    private EdgeCursor edgeCursor;
    private DimensionNavigator navigator;
    private DimensionAxis dimensionAxis;

    DimensionCursorImpl(EdgeCursor edgeCursor, DimensionAxis dimensionAxis, DimensionNavigator navigator) throws OLAPException {
        super(navigator, new DimensionAccessor(dimensionAxis));
        this.edgeCursor = edgeCursor;
        this.dimensionAxis = dimensionAxis;
        this.navigator = navigator;
    }

    public EdgeCursor getEdgeCursor() throws OLAPException {
        return this.edgeCursor;
    }

    public long getEdgeEnd() throws OLAPException {
        if (this.navigator.getPosition() < 0L || this.navigator.getPosition() > (long)this.dimensionAxis.getAssociationQueryResultSet().length()) {
            return -1L;
        }
        return this.dimensionAxis.getEdgeEnd();
    }

    public long getEdgeStart() throws OLAPException {
        if (this.navigator.getPosition() < 0L || this.navigator.getPosition() > (long)this.dimensionAxis.getAssociationQueryResultSet().length()) {
            return -1L;
        }
        return this.dimensionAxis.getEdgeStart();
    }

    public void setEdgeCursor(EdgeCursor value) throws OLAPException {
        this.edgeCursor = value;
    }

    public void setEdgeEnd(long value) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public void setEdgeStart(long value) throws OLAPException {
        throw new UnsupportedOperationException();
    }
}

