/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;

public class DimLevel
implements Comparable {
    private String dimensionName;
    private String levelName;
    private String qualifiedName;
    private String attrName = null;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.DimLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DimLevel(String dimensionName, String levelName) {
        Object[] params = new Object[]{dimensionName, levelName};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.DimLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "DimLevel", params);
        this.dimensionName = dimensionName;
        this.levelName = levelName;
        this.setQualifiedName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.api.DimLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "DimLevel");
    }

    public DimLevel(String dimensionName, String levelName, String attrName) {
        this(dimensionName, levelName);
        this.attrName = attrName;
    }

    public DimLevel(ILevelDefinition levelDefn) {
        this.levelName = levelDefn.getName();
        this.dimensionName = levelDefn.getHierarchy().getDimension().getName();
        this.setQualifiedName();
    }

    private void setQualifiedName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.dimensionName);
        buf.append('/');
        buf.append(this.levelName);
        this.qualifiedName = buf.toString();
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
        result = 31 * result + (this.levelName == null ? 0 : this.levelName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimLevel)) {
            return false;
        }
        DimLevel other = (DimLevel)obj;
        if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
            return false;
        }
        return !(this.levelName == null ? other.levelName != null : !this.levelName.equals(other.levelName));
    }

    public String toString() {
        return this.qualifiedName;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof DimLevel)) {
            return -1;
        }
        DimLevel dimLevel = (DimLevel)obj;
        return this.toString().compareTo(dimLevel.toString());
    }
}

