/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggregationSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AxisQualifier;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.SortKey;

public class AggrSortHelper {
    public static IAggregationResultSet sort(List sorts, IAggregationResultSet[] resultSet) throws DataException {
        try {
            LinkedHashMap map = new LinkedHashMap();
            Iterator it = sorts.iterator();
            while (it.hasNext()) {
                AggrSortDefinition sort = (AggrSortDefinition)it.next();
                if (map.get(sort.getTargetLevel()) == null) {
                    ArrayList<AggrSortDefinition> temp = new ArrayList<AggrSortDefinition>();
                    temp.add(sort);
                    map.put(sort.getTargetLevel(), temp);
                    continue;
                }
                ((List)map.get(sort.getTargetLevel())).add(sort);
            }
            SortKey[] sortKeys = new SortKey[map.size()];
            Object[] keys = map.keySet().toArray();
            int n = 0;
            while (n < keys.length) {
                List aggrSorts = (List)map.get(keys[n]);
                IAggregationResultSet matchedResultSet = AggrSortHelper.getMatchedResultSet(resultSet, ((AggrSortDefinition)aggrSorts.get(0)).getAggrLevels());
                DimLevel targetLevelName = ((AggrSortDefinition)aggrSorts.get(0)).getTargetLevel();
                DimLevel[] levelNames = ((AggrSortDefinition)aggrSorts.get(0)).getAxisQualifierLevel();
                int[] levelIndex = new int[levelNames.length];
                int k = 0;
                while (k < levelIndex.length) {
                    levelIndex[k] = matchedResultSet.getLevelIndex(levelNames[k]);
                    ++k;
                }
                AxisQualifier[] qualifiers = new AxisQualifier[aggrSorts.size()];
                int i = 0;
                while (i < qualifiers.length) {
                    qualifiers[i] = new AxisQualifier(levelIndex, ((AggrSortDefinition)aggrSorts.get(i)).getAxisQualifierValue());
                    ++i;
                }
                int[] aggrIndex = new int[aggrSorts.size()];
                boolean[] aggrDir = new boolean[aggrSorts.size()];
                int i2 = 0;
                while (i2 < aggrSorts.size()) {
                    AggrSortDefinition sort = (AggrSortDefinition)aggrSorts.get(i2);
                    aggrIndex[i2] = matchedResultSet.getAggregationIndex(sort.getAggrName());
                    aggrDir[i2] = sort.getDirection();
                    ++i2;
                }
                int targetLevelOffset = 0;
                if (qualifiers[0].getLevelIndex().length > 0 && qualifiers[0].getLevelIndex()[0] == 0) {
                    targetLevelOffset = qualifiers[0].getLevelIndex().length;
                }
                sortKeys[n] = new SortKey(aggrIndex, aggrDir, matchedResultSet.getLevelIndex(targetLevelName), targetLevelOffset, matchedResultSet, qualifiers);
                ++n;
            }
            IAggregationResultSet base = null;
            int i = 0;
            while (i < resultSet.length) {
                if (AggrSortHelper.isEdgeResultSet(resultSet[i]) && resultSet[i].getLevelIndex((DimLevel)keys[0]) >= 0) {
                    base = resultSet[i];
                    break;
                }
                ++i;
            }
            return AggregationSortHelper.sort(base, sortKeys);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public static boolean isEdgeResultSet(IAggregationResultSet resultSet) {
        return resultSet.getAggregationDefinition() == null || resultSet.getAggregationDefinition().getAggregationFunctions() == null;
    }

    private static IAggregationResultSet getMatchedResultSet(IAggregationResultSet[] resultSet, DimLevel[] levelNames) throws DataException {
        int i = 0;
        while (i < resultSet.length) {
            IAggregationResultSet rSet = resultSet[i];
            if (levelNames.length == rSet.getLevelCount()) {
                boolean match = true;
                int j = 0;
                while (j < rSet.getLevelCount()) {
                    if (!levelNames[j].equals(rSet.getLevel(j))) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match && !AggrSortHelper.isEdgeResultSet(rSet)) {
                    return rSet;
                }
            }
            ++i;
        }
        throw new DataException("data.olap.invalidSortDefinition");
    }
}

