/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionFilterDefn;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionSortDefn;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class DimensionResultIterator
implements IDimensionResultIterator {
    private Dimension dimension;
    private IDiskArray dimensionPosition;
    private IDiskArray dimensionRows;
    private int currentPosition;
    private ILevel[] levels;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public DimensionResultIterator(Dimension dimension, IDiskArray dimensionPosition) throws IOException {
        Object[] params = new Object[]{dimension, dimensionPosition};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "DimensionResultIterator", params);
        this.dimension = dimension;
        this.dimensionPosition = dimensionPosition;
        this.levels = dimension.getHierarchy().getLevels();
        this.dimensionRows = dimension.getDimensionRowByPositions(dimensionPosition);
        this.currentPosition = 0;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "DimensionResultIterator");
    }

    public void close() throws BirtException, IOException {
        this.dimensionPosition.close();
        this.dimensionRows.close();
    }

    public IDimensionResultIterator filter(IDimensionFilterDefn filterDef) throws BirtException {
        return null;
    }

    public IDimension getDimesion() {
        return this.dimension;
    }

    public int getDimesionPosition() throws BirtException, IOException {
        return (Integer)this.dimensionPosition.get(this.currentPosition);
    }

    public Object getLevelAttribute(int levelIndex, int attributeIndex) throws IOException {
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    public int getLevelAttributeDataType(String levelName, String attributeName) {
        return this.levels[this.getLevelIndex(levelName)].getAttributeDataType(attributeName);
    }

    public int getLevelAttributeIndex(String levelName, String attributeName) {
        String[] attributeNames = this.levels[this.getLevelIndex(levelName)].getAttributeNames();
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeNames[i].equals(attributeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getLevelIndex(String levelName) {
        int i = 0;
        while (i < this.levels.length) {
            if (this.levels[i].getName().equals(levelName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getLevelKeyDataType(String levelName) {
        int levelIndex = this.getLevelIndex(levelName);
        if (levelIndex < 0) {
            return null;
        }
        String[] keyNames = this.levels[levelIndex].getKeyNames();
        int[] result = new int[keyNames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.levels[levelIndex].getKeyDataType(keyNames[i]);
            ++i;
        }
        return result;
    }

    public Object[] getLevelKeyValue(int levelIndex) throws IOException {
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex].getKeyValues();
    }

    public ILevel[] getLevels() {
        return this.levels;
    }

    public int length() {
        return this.dimensionRows.size();
    }

    public void seek(int index) {
        this.currentPosition = index;
    }

    public void sort(IDimensionSortDefn sortDef) throws BirtException {
    }

    public Member getLevelMember(int levelIndex) throws IOException {
        return ((DimensionRow)this.dimensionRows.get(this.currentPosition)).getMembers()[levelIndex];
    }

    public DimensionRow getDimensionRow() throws IOException {
        return (DimensionRow)this.dimensionRows.get(this.currentPosition);
    }
}

