/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.util.HashSet;
import java.util.Set;

class DimensionDivider {
    DimensionDivider() {
    }

    static int[] divideDimension(int[] dimensionLength, int blockNumber) {
        HashSet indexSet = new HashSet();
        int[] subDimensionCount = new int[dimensionLength.length];
        int i = 0;
        while (i < subDimensionCount.length) {
            subDimensionCount[i] = 1;
            ++i;
        }
        if (blockNumber > 1) {
            DimensionDivider.calculateSubDimensionCount(dimensionLength, blockNumber, subDimensionCount, indexSet);
        }
        return subDimensionCount;
    }

    private static void calculateSubDimensionCount(int[] dimensionLength, int maxSubDimensionCount, int[] subDimensionCount, Set indexSet) {
        if (indexSet.size() == subDimensionCount.length) {
            return;
        }
        int i = 0;
        while (i < subDimensionCount.length) {
            if (!indexSet.contains(new Integer(i))) {
                if (subDimensionCount[i] + 1 > dimensionLength[i]) {
                    indexSet.add(new Integer(i));
                } else {
                    int n = i;
                    subDimensionCount[n] = subDimensionCount[n] + 1;
                    if (DimensionDivider.isOver(subDimensionCount, maxSubDimensionCount)) {
                        int n2 = i;
                        subDimensionCount[n2] = subDimensionCount[n2] - 1;
                        return;
                    }
                }
            }
            ++i;
        }
        DimensionDivider.calculateSubDimensionCount(dimensionLength, maxSubDimensionCount, subDimensionCount, indexSet);
    }

    private static boolean isOver(int[] candidateArray, int target) {
        int candidate = 1;
        int i = 0;
        while (i < candidateArray.length) {
            if ((candidate *= candidateArray[i]) > target) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

