/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.cube.StopSign;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Traversalor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FTSUDocumentObjectNamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.MeasureList;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.SelectedSubDimension;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class FactTableRowIterator
implements IFactTableRowIterator {
    private FactTable factTable;
    private MeasureInfo[] measureInfo;
    private IDiskArray[] selectedPos;
    private int[] dimensionIndex;
    private int[] currentSubDim;
    private List[] selectedSubDim = null;
    private IDocumentObject currentSegment;
    private int[] currentPos;
    private Object[] currentMeasures;
    private MeasureList measureList;
    private Object[] computedMeasureNames;
    private Object[] currentComputedMeasures;
    private Traversalor traversalor;
    private StopSign stopSign;
    private int[][] selectedPosOfCurSegment;
    private IComputedMeasureHelper computedMeasureHelper;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, StopSign stopSign) throws IOException {
        this(factTable, dimensionName, dimensionPos, null, stopSign);
    }

    public FactTableRowIterator(FactTable factTable, String[] dimensionName, IDiskArray[] dimensionPos, IComputedMeasureHelper computedMeasureHelper, StopSign stopSign) throws IOException {
        Object[] params = new Object[]{factTable, dimensionName, dimensionPos, stopSign};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "FactTableRowIterator", params);
        this.factTable = factTable;
        this.measureInfo = factTable.getMeasureInfo();
        this.selectedPos = dimensionPos;
        this.selectedSubDim = new List[factTable.getDimensionInfo().length];
        this.selectedPosOfCurSegment = new int[factTable.getDimensionInfo().length][];
        this.stopSign = stopSign;
        this.computedMeasureHelper = computedMeasureHelper;
        if (!$assertionsDisabled && dimensionName.length != dimensionPos.length) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.selectedSubDim.length) {
            this.selectedSubDim[i] = new ArrayList();
            ++i;
        }
        this.dimensionIndex = new int[factTable.getDimensionInfo().length];
        i = 0;
        while (i < this.dimensionIndex.length) {
            this.dimensionIndex[i] = -1;
            ++i;
        }
        i = 0;
        while (i < dimensionName.length) {
            this.dimensionIndex[factTable.getDimensionIndex((String)dimensionName[i])] = i;
            ++i;
        }
        this.filterSubDimension();
        this.currentPos = new int[factTable.getDimensionInfo().length];
        this.currentMeasures = new Object[factTable.getMeasureInfo().length];
        this.measureList = new MeasureList(this.measureInfo);
        if (this.computedMeasureHelper != null) {
            this.computedMeasureNames = this.computedMeasureHelper.getAllComputedMeasureNames();
        }
        this.nextSegment();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "FactTableRowIterator");
    }

    private void filterSubDimension() throws IOException {
        DimensionDivision[] dimensionDivisions = this.factTable.getDimensionDivision();
        SelectedSubDimension selectedSubDimension = null;
        int[] selectedSubDimensionCount = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < this.selectedSubDim.length) {
            int pointer = 0;
            int j = 0;
            while (j < dimensionDivisions[i].getRanges().length) {
                if (this.dimensionIndex[i] > -1) {
                    while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) < dimensionDivisions[i].getRanges()[j].start) {
                        ++pointer;
                    }
                    if (pointer >= this.selectedPos[this.dimensionIndex[i]].size()) break;
                    if ((Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                        selectedSubDimension = new SelectedSubDimension();
                        selectedSubDimension.subDimensionIndex = j;
                        selectedSubDimension.start = pointer;
                        while (pointer < this.selectedPos[this.dimensionIndex[i]].size() && (Integer)this.selectedPos[this.dimensionIndex[i]].get(pointer) <= dimensionDivisions[i].getRanges()[j].end) {
                            ++pointer;
                        }
                        selectedSubDimension.end = pointer - 1;
                        this.selectedSubDim[i].add(selectedSubDimension);
                    }
                } else {
                    selectedSubDimension = new SelectedSubDimension();
                    selectedSubDimension.subDimensionIndex = j;
                    selectedSubDimension.start = -1;
                    selectedSubDimension.end = -1;
                    this.selectedSubDim[i].add(selectedSubDimension);
                }
                ++j;
            }
            selectedSubDimensionCount[i] = this.selectedSubDim[i].size();
            ++i;
        }
        this.traversalor = new Traversalor(selectedSubDimensionCount);
    }

    public boolean next() throws IOException {
        while (!this.stopSign.isStopped()) {
            block7: {
                if (this.currentSegment != null) break block7;
                return false;
            }
            try {
                Bytes combinedDimensionPosition = this.currentSegment.readBytes();
                this.currentPos = this.factTable.getCombinedPositionCalculator().calculateDimensionPosition(this.getSubDimensionIndex(), combinedDimensionPosition.bytesValue());
                int i = 0;
                while (i < this.currentMeasures.length) {
                    this.currentMeasures[i] = DocumentObjectUtil.readValue(this.currentSegment, this.measureInfo[i].dataType);
                    ++i;
                }
                if (this.computedMeasureHelper != null) {
                    this.measureList.setMeasureValue(this.currentMeasures);
                    this.currentComputedMeasures = this.computedMeasureHelper.computeMeasureValues(this.measureList);
                }
                if (!this.isSelectedRow()) continue;
                return true;
            }
            catch (EOFException eOFException) {
                break;
            }
        }
        if (this.stopSign.isStopped() || !this.nextSegment()) {
            return false;
        }
        return this.next();
    }

    private int[] getSubDimensionIndex() {
        int[] result = new int[this.selectedSubDim.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ((SelectedSubDimension)this.selectedSubDim[i].get((int)this.currentSubDim[i])).subDimensionIndex;
            ++i;
        }
        return result;
    }

    private boolean isSelectedRow() throws IOException {
        int i = 0;
        while (i < this.currentPos.length) {
            if (this.dimensionIndex[i] != -1) {
                boolean find = false;
                int j = 0;
                while (j < this.selectedPosOfCurSegment[i].length) {
                    if (this.selectedPosOfCurSegment[i][j] > this.currentPos[i]) {
                        return false;
                    }
                    if (this.selectedPosOfCurSegment[i][j] == this.currentPos[i]) {
                        find = true;
                        break;
                    }
                    ++j;
                }
                if (!find) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean nextSegment() throws IOException {
        if (this.stopSign.isStopped()) {
            return false;
        }
        if (!this.traversalor.next()) {
            return false;
        }
        this.currentSubDim = this.traversalor.getIntArray();
        this.currentSegment = this.factTable.getDocumentManager().openDocumentObject(FTSUDocumentObjectNamingUtil.getDocumentObjectName(NamingUtil.getFactTableName(this.factTable.getName()), this.getSubDimensionIndex()));
        int i = 0;
        while (i < this.dimensionIndex.length) {
            if (this.dimensionIndex[i] != -1) {
                SelectedSubDimension selectedSubDimension = (SelectedSubDimension)this.selectedSubDim[i].get(this.currentSubDim[i]);
                this.selectedPosOfCurSegment[i] = new int[selectedSubDimension.end - selectedSubDimension.start + 1];
                int j = 0;
                while (j < selectedSubDimension.end - selectedSubDimension.start + 1) {
                    this.selectedPosOfCurSegment[i][j] = (Integer)this.selectedPos[this.dimensionIndex[i]].get(selectedSubDimension.start + j);
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public int getDimensionCount() {
        return this.factTable.getDimensionInfo().length;
    }

    public int getDimensionIndex(String dimensionName) {
        return this.factTable.getDimensionIndex(dimensionName);
    }

    public int getMeasureIndex(String measureName) {
        int reValue = this.factTable.getMeasureIndex(measureName);
        if (reValue < 0 && this.computedMeasureNames != null) {
            int i = 0;
            while (i < this.computedMeasureNames.length) {
                if (measureName.equals(this.computedMeasureNames[i])) {
                    reValue = i + this.measureInfo.length;
                }
                ++i;
            }
        }
        return reValue;
    }

    public int getDimensionPosition(int dimensionIndex) {
        return this.currentPos[dimensionIndex];
    }

    public int getMeasureCount() {
        if (this.computedMeasureNames != null) {
            return this.currentMeasures.length + this.computedMeasureNames.length;
        }
        return this.currentMeasures.length;
    }

    public Object getMeasure(int measureIndex) {
        if (measureIndex < this.currentMeasures.length) {
            return this.currentMeasures[measureIndex];
        }
        if (measureIndex - this.currentMeasures.length < this.currentComputedMeasures.length) {
            return this.currentComputedMeasures[measureIndex - this.currentMeasures.length];
        }
        return null;
    }

    public MeasureInfo[] getMeasureInfo() {
        return this.measureInfo;
    }
}

