/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.IOUtil;
import org.eclipse.birt.data.engine.olap.data.util.IObjectReader;
import org.eclipse.birt.data.engine.olap.data.util.IObjectWriter;
import org.eclipse.birt.data.engine.olap.data.util.IStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;

public class StructureDiskArray
extends BaseDiskArray {
    private IStructureCreator creator;
    private IObjectWriter[] fieldWriters;
    private IObjectReader[] fieldReaders;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.util.StructureDiskArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public StructureDiskArray(IStructureCreator creator) throws IOException {
        this.creator = creator;
    }

    protected void writeObject(Object object) throws IOException {
        if (object == null) {
            this.randomAccessFile.writeShort(-1);
            return;
        }
        IStructure cachedObject = (IStructure)object;
        Object[] objects = cachedObject.getFieldValues();
        this.randomAccessFile.writeShort((short)objects.length);
        if (this.fieldWriters == null) {
            this.createReaderAndWriter(objects);
        }
        int i = 0;
        while (i < objects.length) {
            if (!$assertionsDisabled && objects[i] == null) {
                throw new AssertionError();
            }
            this.fieldWriters[i].write(this.randomAccessFile, objects[i]);
            ++i;
        }
    }

    private void createReaderAndWriter(Object[] objects) {
        this.fieldWriters = new IObjectWriter[objects.length];
        this.fieldReaders = new IObjectReader[objects.length];
        int i = 0;
        while (i < objects.length) {
            if (!$assertionsDisabled && objects[i] == null) {
                throw new AssertionError();
            }
            this.fieldWriters[i] = IOUtil.getRandomWriter(DataType.getDataType(objects[i].getClass()));
            this.fieldReaders[i] = IOUtil.getRandomReader(DataType.getDataType(objects[i].getClass()));
            ++i;
        }
    }

    protected Object readObject() throws IOException {
        short fieldCount = this.randomAccessFile.readShort();
        if (fieldCount == -1) {
            return null;
        }
        Object[] objects = new Object[fieldCount];
        int i = 0;
        while (i < objects.length) {
            objects[i] = this.fieldReaders[i].read(this.randomAccessFile);
            ++i;
        }
        return this.creator.createInstance(objects);
    }

    public void clear() throws IOException {
        this.fieldWriters = null;
        this.fieldReaders = null;
        super.clear();
    }
}

