/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfoGenerator;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

public class EdgeAxis {
    private DimensionAxis[] dimensionAxis = null;
    private IAggregationResultSet rs;
    private EdgeInfoGenerator edgeInfoUtil;
    private List sortList = null;
    private boolean isPage = false;

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, boolean isPage) throws IOException {
        this(resultSet, view, null, isPage);
    }

    public EdgeAxis(IAggregationResultSet resultSet, BirtEdgeView view, List sortList, boolean isPage) throws IOException {
        this.rs = resultSet;
        this.sortList = sortList;
        this.isPage = isPage;
        this.populateDimensionAxis(resultSet, view);
    }

    private void populateDimensionAxis(IAggregationResultSet rs, BirtEdgeView view) throws IOException {
        ArrayList<DimensionAxis> dimensionAxisList = new ArrayList<DimensionAxis>();
        int mirrorStartLevel = view.getMirrorStartingLevel();
        int index = 0;
        if (!this.isPage) {
            int levelIndex = 0;
            int i = 0;
            while (i < view.getDimensionViews().size()) {
                BirtDimensionView dv = (BirtDimensionView)view.getDimensionViews().get(i);
                Iterator levelIter = dv.getMemberSelection().iterator();
                while (levelIter.hasNext()) {
                    levelIter.next();
                    DimensionAxis axis = null;
                    if (mirrorStartLevel != 0 && levelIndex >= mirrorStartLevel) {
                        axis = new DimensionAxis(this, rs, index, levelIndex, 0, true, this.findAggregationSort(levelIndex));
                        ++levelIndex;
                    } else {
                        axis = new DimensionAxis(this, rs, index, levelIndex++, 0);
                    }
                    ++index;
                    dimensionAxisList.add(axis);
                }
                ++i;
            }
        } else if (this.isPage) {
            DimensionAxis axis = new DimensionAxis(this, rs, index, 0, 0);
            dimensionAxisList.add(axis);
        }
        this.dimensionAxis = new DimensionAxis[dimensionAxisList.size()];
        int i = 0;
        while (i < dimensionAxisList.size()) {
            this.dimensionAxis[i] = (DimensionAxis)dimensionAxisList.get(i);
            ++i;
        }
        this.edgeInfoUtil = new EdgeInfoGenerator(rs, this.dimensionAxis, view.getMirrorStartingLevel());
        i = 0;
        while (i < this.dimensionAxis.length) {
            this.dimensionAxis[i].setEdgeInfo(this.edgeInfoUtil);
            ++i;
        }
    }

    public void populateEdgeInfo() throws OLAPException {
        if (this.edgeInfoUtil != null) {
            try {
                this.edgeInfoUtil.populateEdgeInfo(this.isPage);
            }
            catch (IOException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
    }

    private AggrSortDefinition findAggregationSort(int levelIndex) {
        AggrSortDefinition aggrSortDefn = null;
        if (this.sortList != null) {
            DimLevel level = this.rs.getLevel(levelIndex);
            int i = 0;
            while (i < this.sortList.size()) {
                if (level.equals(aggrSortDefn.getTargetLevel())) {
                    aggrSortDefn = (AggrSortDefinition)this.sortList.get(i);
                    break;
                }
                ++i;
            }
        }
        return aggrSortDefn;
    }

    public EdgeInfoGenerator getEdgeInfo() {
        return this.edgeInfoUtil;
    }

    public DimensionAxis getDimensionAxis(int index) {
        return this.dimensionAxis[index];
    }

    public DimensionAxis[] getAllDimensionAxis() {
        return this.dimensionAxis;
    }

    public IAggregationResultSet getQueryResultSet() {
        return this.rs;
    }

    public EdgeInfoGenerator getEdgeInfoUtil() {
        return this.edgeInfoUtil;
    }
}

