/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field(), "");
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery query = new BooleanQuery(true);
        TermEnum enumerator = reader.terms(this.lowerTerm);
        try {
            Term term;
            boolean checkLower = false;
            if (!this.inclusive) {
                checkLower = true;
            }
            String testField = this.getField();
            while ((term = enumerator.term()) != null && term.field() == testField) {
                block7: {
                    int compare;
                    if (checkLower && term.text().compareTo(this.lowerTerm.text()) <= 0) break block7;
                    checkLower = false;
                    if (this.upperTerm != null && ((compare = this.upperTerm.text().compareTo(term.text())) < 0 || !this.inclusive && compare == 0)) break;
                    TermQuery tq = new TermQuery(term);
                    tq.setBoost(this.getBoost());
                    query.add(tq, BooleanClause.Occur.SHOULD);
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            enumerator.close();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        enumerator.close();
        return query;
    }

    public String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public Term getLowerTerm() {
        return this.lowerTerm;
    }

    public Term getUpperTerm() {
        return this.upperTerm;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeQuery)) {
            return false;
        }
        RangeQuery other = (RangeQuery)o;
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (this.inclusive != other.inclusive) {
            return false;
        }
        if (this.lowerTerm != null ? !this.lowerTerm.equals(other.lowerTerm) : other.lowerTerm != null) {
            return false;
        }
        return !(this.upperTerm != null ? !this.upperTerm.equals(other.upperTerm) : other.upperTerm != null);
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.getBoost());
        h ^= this.lowerTerm != null ? this.lowerTerm.hashCode() : 0;
        h ^= h << 25 | h >>> 8;
        h ^= this.upperTerm != null ? this.upperTerm.hashCode() : 0;
        return h ^= this.inclusive ? 658696010 : 0;
    }
}

