/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class PPTWriter {
    protected static Logger logger;
    private PrintWriter writer;
    protected int currentPageNum;
    private int shapeCount;
    protected float pageWidth;
    protected float pageHeight;
    private Map imageNames;
    private List imageTitles;
    private Map imageExtensions;
    private Map fileNamesLists;
    private Map currentImageData;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.emitter.ppt.PPTWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.ppt.PPTRender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public PPTWriter(OutputStream output) {
        block2: {
            this.writer = null;
            this.currentPageNum = 0;
            this.shapeCount = 0;
            this.imageNames = new HashMap();
            this.imageTitles = new ArrayList();
            this.imageExtensions = new HashMap();
            this.fileNamesLists = new TreeMap();
            this.currentImageData = new HashMap();
            try {
                this.writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void start() {
        if (!this.imageNames.isEmpty()) {
            this.imageNames.clear();
        }
        if (!this.fileNamesLists.isEmpty()) {
            this.fileNamesLists.clear();
        }
        this.println("MIME-Version: 1.0");
        this.println("Content-Type: multipart/related; boundary=\"___Actuate_Content_Boundary___\"");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file:///C:/___Actuate___/slide-show");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println("xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println("xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println("xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println("xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.println("<meta name=3D'ProgId' content=3D'PowerPoint.Slide'>");
        this.println("<meta name=3D'Generator' content=3D'Actuate View Server'>");
        this.println("<title>Actuate Report</title>");
        this.println("<xml><o:DocumentProperties>");
        this.println("<o:Author>Actuate View Server</o:Author>");
        this.println("</o:DocumentProperties></xml><link rel=3DFile-List href=3D'file-list'>");
        this.println("<link rel=3DPresentation-XML href=3D'presentation'>");
        this.println("</head><body/></html>");
    }

    private void print(String text) {
        this.writer.print(text);
    }

    private void println(String text) {
        this.writer.println(text);
    }

    private void print(byte[] data) {
        this.print(new String(data));
    }

    public void end() {
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file:///C:/___Actuate___/presentation");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<p:presentation sizeof=3D'custom' slidesizex=3D'" + this.pageWidth * 8.0f + "' slidesizey=3D'" + this.pageHeight * 8.0f + "'>");
        int i = 0;
        while (i < this.currentPageNum) {
            this.println("<p:slide id=3D'" + (i + 1) + "' href=3D's" + (i + 1) + "'/>");
            ++i;
        }
        this.println("</p:presentation></xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file:///C:/___Actuate___/file-list");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<o:MainFile href=3D'slide-show'/>");
        this.println("<o:File href=3D'presentation'/>");
        this.println("<o:File href=3D'file-list'/>");
        i = 0;
        while (i < this.currentPageNum) {
            this.println("<o:File href=3D's" + (i + 1) + "'/>");
            if (this.fileNamesLists.containsKey(new Integer(i + 1))) {
                List filenames = (List)this.fileNamesLists.get(new Integer(i + 1));
                Iterator ite = filenames.iterator();
                while (ite.hasNext()) {
                    this.println("<o:File href=3D\"" + (String)ite.next() + "\"/>");
                }
            }
            ++i;
        }
        this.println("</xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___--");
        this.writer.close();
        this.writer = null;
    }

    public void endPage() {
        try {
            Iterator ite = this.imageTitles.iterator();
            while (ite.hasNext()) {
                String imageTitle = (String)ite.next();
                byte[] imageData = (byte[])this.currentImageData.get(imageTitle);
                this.generateImageBytes(imageTitle, imageData);
                this.println("\n");
            }
            this.println("</p:slide></body></html>");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private void exportImageHeader(String imagekey) throws IOException {
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file:///C:/___Actuate___/" + (String)this.imageNames.get(imagekey));
        this.println("Content-Transfer-Encoding: base64");
        this.println("Content-Type: image/" + (String)this.imageExtensions.get(imagekey) + "\n");
    }

    private void generateImageBytes(String imageTitle, byte[] imageData) throws IOException {
        this.exportImageHeader(imageTitle);
        Base64 base = new Base64();
        this.print(base.encode(imageData));
    }

    public void newPage(float pageWidth, float pageHeight, Color backgroundColor) {
        ++this.currentPageNum;
        this.currentImageData.clear();
        this.imageTitles.clear();
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file:///C:/___Actuate___/s" + this.currentPageNum);
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println(" xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(" xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head/><body><p:slide>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.drawBackgroundColor(backgroundColor, 0.0, 0.0, pageWidth, pageHeight);
    }

    private String getFontName(BaseFont baseFont) {
        String[][] familyFontNames = baseFont.getFamilyFontName();
        String[] family = familyFontNames[0];
        String fontName = family[family.length - 1];
        return fontName;
    }

    public void drawText(String text, float textX, float textY, float width, float height, FontInfo fontInfo, Color color) {
        boolean isBold;
        BaseFont baseFont = fontInfo.getBaseFont();
        String fontName = this.getFontName(baseFont);
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        red = red.length() == 1 ? "0" + red : red;
        green = green.length() == 1 ? "0" + green : green;
        blue = blue.length() == 1 ? "0" + blue : blue;
        this.println("<v:shape id=3D't" + ++this.shapeCount + "' type=3D'#r'");
        this.println(" style=3D'position:absolute;left:" + textX + "pt;top:" + textY + "pt;width:" + width + "pt;height:" + height + "pt;v-text-anchor:top;mso-wrap-style:square;'");
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.println("<v:textbox style=3D'mso-fit-shape-to-text:f;' inset=3D'0.00pt 0.00pt 0.00pt 0.00pt'/>");
        this.println("</v:shape>");
        this.println("<div v:shape=3D't" + this.shapeCount + "'>");
        this.println("<div style=3D'mso-text-indent-alt:0;text-align:left;'><span style=3D'font-family:" + fontName + ";font-size:" + fontInfo.getFontSize() + "pt;color:#" + red + green + blue + ";'>");
        boolean isItalic = fontInfo != null && (fontInfo.getFontStyle() & 2) != 0;
        boolean bl = isBold = fontInfo != null && (fontInfo.getFontStyle() & 1) != 0;
        if (isItalic) {
            this.print("<i>");
        }
        if (isBold) {
            this.print("<b>");
        }
        this.print(text);
        if (isBold) {
            this.print("</b>");
        }
        if (isItalic) {
            this.print("</i>");
        }
        this.println("</span></div>");
        this.println("</div>");
    }

    public void drawImage(byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        String imageName;
        String imageTitle = "slide" + this.currentPageNum + "_image" + ++this.shapeCount;
        this.imageTitles.add(imageTitle);
        if (this.imageNames.containsKey(imageTitle)) {
            imageName = (String)this.imageNames.get(imageTitle);
        } else {
            imageName = String.valueOf(imageTitle) + "." + extension;
            this.imageNames.put(imageTitle, imageName);
            this.imageExtensions.put(imageTitle, extension);
            this.recordFileLists(imageName);
            this.currentImageData.put(imageTitle, imageData);
        }
        this.exportImageDefn(imageName, imageTitle, width, height, imageX, imageY);
    }

    private void exportImageDefn(String imageName, String imageTitle, double width, double height, double x, double y) {
        this.println("<v:shape id=3D'" + this.shapeCount + "' type=3D'#r'");
        this.println(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.println("<v:imagedata src=3D\"" + imageName + "\" o:title=3D\"" + imageTitle + "\"/>");
        this.println("<o:lock v:ext=3D'edit' aspectratio=3D't'/>");
        this.println("</v:shape>");
    }

    private String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }

    private void recordFileLists(String filename) {
        Integer pageNum = new Integer(this.currentPageNum);
        if (this.fileNamesLists.containsKey(pageNum)) {
            ((List)this.fileNamesLists.get(pageNum)).add(filename);
        } else {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(filename);
            this.fileNamesLists.put(pageNum, fileNames);
        }
    }

    public void drawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        if (color == null || 0.0 == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        if (lineStyle.equalsIgnoreCase("solid") || lineStyle.equalsIgnoreCase("dashed") || lineStyle.equalsIgnoreCase("dotted") || lineStyle.equalsIgnoreCase("double")) {
            this.drawRawLine(startX, startY, endX, endY, width, color, lineStyle);
        } else {
            this.drawRawLine(startX, startY, endX, endY, width, color, "solid");
        }
    }

    private void drawRawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        this.print("<v:line id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute' from=3D\"" + startX + "pt," + startY + "pt\"");
        this.print(" to=3D\"" + endX + "pt," + endY + "pt\"");
        this.print(" strokecolor=3D\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"");
        this.print(" strokeweight=3D\"" + width + "pt\"");
        if (lineStyle.equalsIgnoreCase("dashed")) {
            this.println("<v:stroke dashstyle=3D\"dash\"/>");
        } else if (lineStyle.equalsIgnoreCase("dotted")) {
            this.println("<v:stroke dashstyle=3D\"1 1\"/>");
        } else if (lineStyle.equalsIgnoreCase("double")) {
            this.println("<v:stroke linestyle=3D\"thinThin\"/>");
        } else {
            this.println("/>");
            return;
        }
        this.println(">");
        this.println("</v:line>");
    }

    public void drawBackgroundColor(Color color, double x, double y, double width, double height) {
        if (color == null) {
            return;
        }
        this.print("<v:rect id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        this.print(" fillcolor=3D\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"");
        this.println(" stroked=3D\"f\"/>");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float positionX, float positionY, String repeat) {
        String imageName;
        byte[] imageData;
        float imageHeight;
        float imageWidth;
        block13: {
            if (imageURI == null) return;
            if (imageURI.length() == 0) {
                return;
            }
            imageWidth = 0.0f;
            imageHeight = 0.0f;
            imageData = null;
            InputStream imageStream = null;
            try {
                try {
                    URL url = new URL(imageURI);
                    imageStream = url.openStream();
                    imageData = this.getImageData(imageStream);
                    imageStream.close();
                    imageStream = url.openStream();
                    BufferedImage image = ImageIO.read(imageStream);
                    ImageIcon imageIcon = new ImageIcon(image);
                    imageWidth = imageIcon.getIconWidth();
                    imageHeight = imageIcon.getIconHeight();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe.getMessage(), ioe);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                if (imageStream == null) throw throwable;
                try {
                    imageStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var16_20 = null;
                if (imageStream == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            imageStream.close();
        }
        String imageTitle = "slide" + this.currentPageNum + "_image" + ++this.shapeCount;
        this.imageTitles.add(imageTitle);
        if (this.imageNames.containsKey(imageURI)) {
            imageName = (String)this.imageNames.get(imageURI);
        } else {
            String extension = this.getImageExtension(imageURI);
            imageName = String.valueOf(imageTitle) + "." + extension;
            this.imageNames.put(imageTitle, imageName);
            this.imageExtensions.put(imageTitle, extension);
            this.recordFileLists(imageName);
            this.currentImageData.put(imageTitle, imageData);
        }
        Position areaPosition = new Position(x, y);
        Position areaSize = new Position(width, height);
        Position imagePosition = new Position(x + positionX, y + positionY);
        Position imageSize = new Position(imageWidth, imageHeight);
        BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
        List positions = layout.getImagePositions(repeat);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            Position position = (Position)iterator.next();
            this.exportImageDefn(imageName, imageTitle, imageWidth, imageHeight, position.getX(), position.getY());
        }
        return;
    }

    private byte[] getImageData(InputStream imageStream) throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        int data = -1;
        while ((data = imageStream.read()) >= 0) {
            byteArrayStream.write(data);
        }
        byte[] imageData = byteArrayStream.toByteArray();
        return imageData;
    }
}

