/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.birt.core.data.DateFormatFactory;
import org.eclipse.birt.core.data.PatternKey;
import org.eclipse.birt.core.exception.BirtException;

public class DateFormatISO8601 {
    public static Date parse(String source) throws BirtException, ParseException {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        Date resultDate = null;
        SimpleDateFormat simpleDateFormatter = DateFormatFactory.getPatternInstance(PatternKey.getPatterKey(source = DateFormatISO8601.cleanDate(source)));
        if (simpleDateFormatter != null) {
            try {
                resultDate = simpleDateFormatter.parse(source);
                return resultDate;
            }
            catch (ParseException parseException) {}
        }
        if (resultDate == null) {
            throw new ParseException("an not convert the value of " + source, 0);
        }
        return resultDate;
    }

    private static String cleanDate(String s) {
        int zoneIndex;
        if ((s = s.trim()).indexOf(84) < 12) {
            s = s.replaceFirst("T", " ");
        }
        if ((zoneIndex = s.indexOf("GMT")) > 0) {
            return s.substring(0, zoneIndex).trim();
        }
        zoneIndex = s.indexOf(90);
        if (zoneIndex == s.length() - 1) {
            return s.substring(0, zoneIndex).trim();
        }
        zoneIndex = s.indexOf(43);
        if (zoneIndex > 0) {
            return s.substring(0, zoneIndex).trim();
        }
        return s;
    }
}

