/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.datafeed.BubbleEntry;
import org.eclipse.birt.chart.datafeed.DataSetAdapter;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.impl.BubbleDataSetImpl;
import org.eclipse.birt.chart.util.CDateTime;

public class BubbleDataSetProcessorImpl
extends DataSetAdapter {
    public Object getMaximum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime cMax = null;
        double dMax = -1.7976931348623157E308;
        int i = 0;
        while (dsi.hasNext()) {
            BubbleEntry bde = (BubbleEntry)dsi.next();
            if (bde != null) {
                Object oValue = bde.getValue();
                if (oValue instanceof Number) {
                    double dValue = ((Number)oValue).doubleValue();
                    dMax = i == 0 ? dValue : Math.max(dMax, dValue);
                } else if (oValue instanceof CDateTime) {
                    CDateTime cValue = (CDateTime)oValue;
                    if (i == 0) {
                        cMax = cValue;
                    } else if (cValue.after((Object)cMax)) {
                        cMax = cValue;
                    }
                }
            }
            ++i;
        }
        if (cMax == null) {
            return new Double(dMax);
        }
        return cMax;
    }

    public Object getMinimum(DataSet ds) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(ds);
            dsi.reset();
        }
        catch (IllegalArgumentException uiex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, (Throwable)uiex);
        }
        if (dsi.size() == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
        }
        CDateTime cMin = null;
        double dMin = Double.MAX_VALUE;
        int i = 0;
        while (dsi.hasNext()) {
            BubbleEntry bde = (BubbleEntry)dsi.next();
            if (bde != null) {
                Object oValue = bde.getValue();
                if (oValue instanceof Number) {
                    double dValue = ((Number)oValue).doubleValue();
                    dMin = i == 0 ? dValue : Math.min(dMin, dValue);
                } else if (oValue instanceof CDateTime) {
                    CDateTime cValue = (CDateTime)oValue;
                    if (i == 0) {
                        cMin = cValue;
                    } else if (cValue.before((Object)cMin)) {
                        cMin = cValue;
                    }
                }
            }
            ++i;
        }
        if (cMin == null) {
            return new Double(dMin);
        }
        return cMin;
    }

    public final DataSet populate(Object oResultSetDef, DataSet ds) throws ChartException {
        if (oResultSetDef instanceof IResultSetDataSet) {
            IResultSetDataSet rsds = (IResultSetDataSet)oResultSetDef;
            long lRowCount = rsds.getSize();
            if (lRowCount <= 0L) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 16, "exception.empty.dataset", Messages.getResourceBundle(this.getULocale()));
            }
            int dataType = rsds.getDataType(0);
            BubbleEntry[] bea = new BubbleEntry[(int)lRowCount];
            int i = 0;
            while (rsds.hasNext()) {
                Object[] oTwoComponents = rsds.next();
                this.validateBubbleEntryData(oTwoComponents);
                Object value = oTwoComponents[0];
                Object size = oTwoComponents[1];
                bea[i] = dataType == 1 ? new BubbleEntry(value, size) : (dataType == 8 ? new BubbleEntry(value == null ? null : new CDateTime((Date)value), size) : new BubbleEntry(value, size, i + 1));
                ++i;
            }
            if (ds == null) {
                ds = BubbleDataSetImpl.create((Object)bea);
            } else {
                ds.setValues((Object)bea);
            }
        } else {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.unknown.custom.dataset", new Object[]{ds, oResultSetDef}, Messages.getResourceBundle(this.getULocale()));
        }
        return ds;
    }

    private void validateBubbleEntryData(Object[] obja) throws ChartException {
        boolean valid = true;
        if (obja == null) {
            valid = false;
        } else if (obja.length != 2) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.dataset.bubbleseries", Messages.getResourceBundle(this.getULocale()));
        }
        if (!valid) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 30, "exception.dataset.null.bubbleentry", Messages.getResourceBundle(this.getULocale()));
        }
    }

    public final DataSet fromString(String sDataSetRepresentation, DataSet ds) throws ChartException {
        if (sDataSetRepresentation == null) {
            return ds;
        }
        if (ds == null) {
            ds = BubbleDataSetImpl.create(null);
        }
        StringTokenizer strTokDataElement = new StringTokenizer(sDataSetRepresentation, ",");
        StringTokenizer strTokComponents = null;
        String strDataElement = null;
        String strComponent = null;
        Vector<BubbleEntry> vData = new Vector<BubbleEntry>();
        while (strTokDataElement.hasMoreTokens()) {
            strDataElement = strTokDataElement.nextToken().trim();
            strTokComponents = new StringTokenizer(strDataElement);
            if (strTokComponents.countTokens() == 1) {
                Double value = null;
                try {
                    value = new Double(Double.parseDouble(strDataElement));
                }
                catch (NumberFormatException numberFormatException) {
                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                    try {
                        value = new CDateTime(sdf.parse(strDataElement));
                    }
                    catch (ParseException parseException) {
                        value = null;
                    }
                }
                vData.add(new BubbleEntry(value, new Integer(5)));
                continue;
            }
            BubbleEntry entry = new BubbleEntry(new Integer(1), new Integer(1));
            while (strTokComponents.hasMoreTokens()) {
                strComponent = strTokComponents.nextToken().trim().toUpperCase();
                if (strComponent.startsWith("Y")) {
                    entry.setValue(strComponent.substring(1));
                    continue;
                }
                if (!strComponent.startsWith("S")) continue;
                entry.setSize(Double.parseDouble(strComponent.substring(1)));
            }
            vData.add(entry);
        }
        ds.setValues(vData);
        return ds;
    }

    public String getExpectedStringFormat() {
        return Messages.getString("info.bubble.sample.format", this.getULocale());
    }

    public String toString(Object[] columnData) throws ChartException {
        if (columnData == null || columnData.length == 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < columnData.length) {
            if (columnData[i] == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "exception.base.orthogonal.null.datadefinition", Messages.getResourceBundle(this.getULocale()));
            }
            if (columnData[i] instanceof Object[]) {
                buffer.append(this.toBubbleString((Object[])columnData[i]));
            }
            if (i < columnData.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private StringBuffer toBubbleString(Object[] bubbleArray) throws ChartException {
        if (bubbleArray.length != 2 || bubbleArray[0] == null) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 1, "Invalid data set column");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Y" + String.valueOf(bubbleArray[0]) + " ");
        buffer.append("S" + String.valueOf(bubbleArray[1]));
        return buffer;
    }

    public List getDataDefinitionsForGrouping(Series series) {
        ArrayList<String> list = new ArrayList<String>(1);
        String sExpression = ((Query)series.getDataDefinition().get(1)).getDefinition();
        if (sExpression != null && sExpression.trim().length() > 0) {
            list.add(sExpression);
        }
        return list;
    }
}

