/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import org.eclipse.birt.chart.computation.Methods;

public class ScaleContext
extends Methods {
    private Object oMinAuto;
    private Object oMaxAuto;
    private Object oMinFixed;
    private Object oMaxFixed;
    private Integer oStepNumber;
    private final int iMarginPercent;
    private final int iType;
    private Object oMin;
    private Object oMax;
    private Object oStep;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private boolean bMargin = false;

    public ScaleContext(int iMarginPercent, int iType, Object oMinAuto, Object oMaxAuto, Object oStep) {
        this.iMarginPercent = iMarginPercent;
        this.iType = iType;
        this.oMinAuto = oMinAuto;
        this.oMaxAuto = oMaxAuto;
        this.oStep = oStep;
        this.bMargin = iMarginPercent > 0;
    }

    public void setFixedValue(boolean bMinimumFixed, boolean bMaximumFixed, Object oMinFixed, Object oMaxFixed) {
        this.oMinFixed = oMinFixed;
        this.oMaxFixed = oMaxFixed;
        this.bMinimumFixed = bMinimumFixed;
        this.bMaximumFixed = bMaximumFixed;
        this.oMin = oMinFixed;
        this.oMax = oMaxFixed;
    }

    public void setFixedStep(boolean bStepFixed, Integer oStepNumber) {
        this.oStepNumber = oStepNumber;
        this.bStepFixed = bStepFixed || oStepNumber != null;
    }

    public Object getMin() {
        return this.oMin;
    }

    public Object getMax() {
        return this.oMax;
    }

    public Object getRealMin() {
        return this.oMinAuto;
    }

    public Object getRealMax() {
        return this.oMaxAuto;
    }

    public Object getStep() {
        return this.oStep;
    }

    public void computeMinMax() {
        double dMargin = 0.0;
        if (this.bMargin) {
            dMargin = Math.abs(ScaleContext.asDouble(this.oMaxAuto) - ScaleContext.asDouble(this.oMinAuto)) * (double)this.iMarginPercent / 100.0;
        }
        double dMinReal = ScaleContext.asDouble(this.oMinAuto) - dMargin;
        double dMaxReal = ScaleContext.asDouble(this.oMaxAuto) + dMargin;
        double dMinValue = this.bMinimumFixed ? ScaleContext.asDouble(this.oMinFixed) : dMinReal;
        double dMaxValue = this.bMaximumFixed ? ScaleContext.asDouble(this.oMaxFixed) : dMaxReal;
        double dMinAxis = dMinValue;
        double dMaxAxis = dMaxValue;
        double dStep = 0.0;
        if (this.bStepFixed && this.oStepNumber != null) {
            this.oStep = new Double(Math.abs(dMaxValue - dMinValue) / (double)this.oStepNumber.intValue());
            dStep = ScaleContext.asDouble(this.oStep);
        } else {
            dStep = ScaleContext.asDouble(this.oStep);
            if (this.bMargin) {
                dMinAxis = (dStep >= 1.0 ? Math.floor(dMinAxis / dStep) : (double)Math.round(dMinAxis / dStep)) * dStep;
                dMaxAxis = ((dStep >= 1.0 ? Math.floor(dMaxAxis / dStep) : (double)Math.round(dMaxAxis / dStep)) + 1.0) * dStep;
                if (dMaxAxis - dMaxValue >= dStep) {
                    dMaxAxis -= dStep;
                }
            } else {
                double dAbsMax = Math.abs(dMaxValue);
                double dAbsMin = Math.abs(dMinValue);
                dMinAxis = (dStep > 1.0 ? Math.floor(dAbsMin / dStep) : (double)Math.round(dAbsMin / dStep)) * dStep;
                dMaxAxis = (dStep > 1.0 ? Math.floor(dAbsMax / dStep) : (double)Math.round(dAbsMax / dStep)) * dStep;
                if (dMinAxis == dAbsMin) {
                    dMinAxis += dStep;
                    if (dMinValue < 0.0) {
                        dMinAxis = -dMinAxis;
                    } else if (dMinValue == 0.0) {
                        dMinAxis = 0.0;
                    }
                } else if (dMinValue < 0.0) {
                    dMinAxis = -(dMinAxis + dStep);
                } else if (dMinAxis >= dMinValue && dMinAxis != 0.0) {
                    dMinAxis -= dStep;
                }
                if (dMaxAxis == dAbsMax) {
                    dMaxAxis += dStep;
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -dMaxAxis;
                    } else if (dMaxValue == 0.0) {
                        dMaxAxis = 0.0;
                    }
                } else if (dMinAxis != dMaxValue) {
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -(dMaxAxis - dStep);
                    } else if (dMaxValue > 0.0 && dMaxAxis < dMaxValue) {
                        dMaxAxis += dStep;
                    }
                }
                if (dMinValue < 0.0 && dMaxValue < 0.0 && dMaxAxis <= dMaxValue - dStep) {
                    dMaxAxis += 2.0 * dStep;
                }
                if (dMinValue > 0.0 && dMaxValue > 0.0 && dMinAxis >= dMinValue + dStep) {
                    dMinAxis -= 2.0 * dStep;
                }
            }
        }
        if (dMinValue == 0.0 && dMaxValue == 0.0) {
            if (dMinAxis >= 0.0) {
                dMinAxis = -1.0;
            }
            if (dMaxAxis <= 0.0) {
                dMaxAxis = 1.0;
            }
        }
        if ((this.iType & 0x20) == 32) {
            if (dMaxAxis > 0.0) {
                dMaxAxis = 100.0;
            }
            if (dMinAxis < 0.0) {
                dMinAxis = -100.0;
            }
        }
        if (!this.bMaximumFixed) {
            this.oMax = new Double(dMaxAxis);
        }
        if (!this.bMinimumFixed) {
            this.oMin = new Double(dMinAxis);
        }
        if (this.bMargin) {
            this.oMinAuto = this.bMinimumFixed && dMinValue > dMinReal ? new Double(dMinReal) : null;
            this.oMaxAuto = this.bMaximumFixed && dMaxValue < dMaxReal ? new Double(dMaxReal) : null;
        } else {
            this.oMinAuto = null;
            this.oMaxAuto = null;
        }
    }
}

