/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.Arc3DRenderEvent;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.Area3DRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.Image3DRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Oval3DRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.Location3DImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.util.ChartUtil;

public final class MarkerRenderer {
    private final IDeviceRenderer iRender;
    private final DeferredCache dc;
    private Fill paletteEntry;
    private LineAttributes la;
    private Marker m;
    private final boolean bDeferred;
    private double iSize;
    private final Object oSource;
    private final boolean bRendering3D;
    private final boolean bTransposed;
    private Location lo;
    private Location3D lo3d;
    private PrimitiveRenderEvent preCopy;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public MarkerRenderer(IDeviceRenderer _render, Object _oSource, Location _lo, LineAttributes _la, Fill _paletteEntry, Marker _m, Integer _markerSize, DeferredCache _dc, boolean _bDeferred, boolean _bTransposed) {
        this.iRender = _render;
        this.la = _la;
        this.dc = _dc;
        this.bDeferred = _bDeferred;
        this.oSource = _oSource;
        this.m = _m;
        this.bTransposed = _bTransposed;
        this.iSize = _markerSize == null ? _m.getSize() : _markerSize.intValue();
        this.paletteEntry = ChartUtil.convertFill(_paletteEntry, this.iSize, ColorDefinitionImpl.TRANSPARENT());
        if (this.paletteEntry instanceof ColorDefinition && ChartUtil.isColorTransparent((ColorDefinition)this.paletteEntry) && (!_la.isVisible() || ChartUtil.isColorTransparent(_la.getColor()))) {
            this.paletteEntry = ColorDefinitionImpl.create(0, 0, 0, 15);
        }
        this.iSize = Math.abs(this.iSize) * (double)this.iRender.getDisplayServer().getDpiResolution() / 72.0;
        this.bRendering3D = _lo instanceof Location3D;
        if (this.bRendering3D) {
            this.lo3d = (Location3D)_lo;
        } else {
            this.lo = _lo;
        }
    }

    public final void draw(IPrimitiveRenderer ipr) throws ChartException {
        switch (this.m.getType().getValue()) {
            case 0: {
                this.drawCrosshair(ipr);
                break;
            }
            case 1: {
                this.drawTriangle(ipr);
                break;
            }
            case 2: {
                this.drawBox(ipr);
                break;
            }
            case 3: {
                this.drawCircle(ipr);
                break;
            }
            case 4: {
                this.drawIcon(ipr);
                break;
            }
            case 5: {
                this.drawNabla(ipr);
                break;
            }
            case 6: {
                this.drawDiamond(ipr);
                break;
            }
            case 7: {
                this.drawFourDiamonds(ipr);
                break;
            }
            case 8: {
                this.drawEllipse(ipr);
                break;
            }
            case 9: {
                this.drawSemiCircle(ipr);
                break;
            }
            case 10: {
                this.drawHexagon(ipr);
                break;
            }
            case 11: {
                this.drawRectangle(ipr);
                break;
            }
            case 12: {
                this.drawStar(ipr);
                break;
            }
            case 13: {
                this.drawColumn(ipr);
                break;
            }
            case 14: {
                this.drawCross(ipr);
            }
        }
    }

    private void drawCrosshair(IPrimitiveRenderer ipr) throws ChartException {
        LineRenderEvent lre3d;
        LineRenderEvent lineRenderEvent;
        if (this.paletteEntry instanceof Gradient) {
            this.paletteEntry = ((Gradient)this.paletteEntry).getStartColor();
        }
        if (!(this.paletteEntry instanceof ColorDefinition)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.illegal.filltype.crosshair.marker", new Object[]{this.paletteEntry}, Messages.getResourceBundle(this.iRender.getULocale()));
        }
        if (ChartUtil.isColorTransparent((ColorDefinition)this.paletteEntry)) {
            this.paletteEntry = ColorDefinitionImpl.create(0, 0, 0, 15);
        }
        ColorDefinition cd = (ColorDefinition)this.paletteEntry;
        LineAttributes lia = LineAttributesImpl.create(ColorDefinitionImpl.copyInstance(cd), LineStyle.SOLID_LITERAL, this.la.getThickness());
        EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.chart.event.LineRenderEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LineRenderEvent lre = (LineRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
        if (this.bRendering3D) {
            EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.birt.chart.event.Line3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            lineRenderEvent = (Line3DRenderEvent)eventObjectCache2.getEventObject(this.oSource, clazz2);
        } else {
            lineRenderEvent = lre3d = null;
        }
        if (this.bRendering3D) {
            lre3d.setLineAttributes(lia);
            ((Line3DRenderEvent)lre3d).setStart3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - this.iSize, this.lo3d.getZ()));
            ((Line3DRenderEvent)lre3d).setEnd3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + this.iSize, this.lo3d.getZ()));
        } else {
            lre.setLineAttributes(lia);
            lre.setStart(LocationImpl.create(this.lo.getX(), this.lo.getY() - this.iSize));
            lre.setEnd(LocationImpl.create(this.lo.getX(), this.lo.getY() + this.iSize));
        }
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize - 1.0, this.lo3d.getZ())};
            EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache3.getEventObject(this.oSource, clazz3);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            this.preCopy = pre;
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize)};
            EventObjectCache eventObjectCache4 = (EventObjectCache)((Object)ipr);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache4.getEventObject(this.oSource, clazz4);
            pre.setPoints(loa);
            this.preCopy = pre;
        }
        if (this.bRendering3D) {
            this.dc.addLine(lre3d);
            lre3d.setLineAttributes(lia);
            ((Line3DRenderEvent)lre3d).setStart3D(Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY(), this.lo3d.getZ()));
            ((Line3DRenderEvent)lre3d).setEnd3D(Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY(), this.lo3d.getZ()));
            this.dc.addLine(lre3d);
        } else {
            if (this.bDeferred) {
                this.dc.addMarker(lre, 1, this.iSize);
            } else {
                ipr.drawLine(lre);
            }
            lre.setLineAttributes(lia);
            lre.setStart(LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY()));
            lre.setEnd(LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY()));
            if (this.bDeferred) {
                this.dc.addMarker(lre, 1, this.iSize);
            } else {
                ipr.drawLine(lre);
            }
        }
    }

    private void drawTriangle(IPrimitiveRenderer ipr) throws ChartException {
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + this.iSize - 1.0, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            pre.setDoubleSided(true);
            this.preCopy = pre;
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[3];
            if (this.bTransposed) {
                loa[0] = LocationImpl.create(this.lo.getX() - this.iSize - 1.0, this.lo.getY() - this.iSize);
                loa[1] = LocationImpl.create(this.lo.getX() - this.iSize - 1.0, this.lo.getY() + this.iSize);
                loa[2] = LocationImpl.create(this.lo.getX() + this.iSize - 1.0, this.lo.getY());
            } else {
                loa[0] = LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + this.iSize - 1.0);
                loa[1] = LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + this.iSize - 1.0);
                loa[2] = LocationImpl.create(this.lo.getX(), this.lo.getY() - this.iSize - 1.0);
            }
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre;
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawBox(IPrimitiveRenderer ipr) throws ChartException {
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize)};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawCircle(IPrimitiveRenderer ipr) throws ChartException {
        if (this.bRendering3D) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.birt.chart.event.Oval3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Oval3DRenderEvent ore = (Oval3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            ore.setBackground(this.paletteEntry);
            ore.setOutline(this.la);
            ore.setLocation3D(new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ())});
            this.preCopy = ore.copy();
            this.dc.addPlane(ore, 3);
        } else {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            OvalRenderEvent ore = (OvalRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            ore.setBackground(this.paletteEntry);
            ore.setBounds(BoundsImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize, this.iSize * 2.0, this.iSize * 2.0));
            ore.setOutline(this.la);
            this.preCopy = ore.copy();
            if (this.bDeferred) {
                this.dc.addMarker(ore, 3, this.iSize);
            } else {
                ipr.fillOval(ore);
                ipr.drawOval(ore);
            }
        }
    }

    private void drawIcon(IPrimitiveRenderer ipr) throws ChartException {
        Fill fil = this.m.getFill();
        if (!(fil instanceof Image)) {
            logger.log(2, Messages.getString("exception.illegal.icon.palette.type.for.marker", new Object[]{fil}, this.iRender.getULocale()));
            return;
        }
        Image icon = (Image)fil;
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            this.preCopy = pre.copy();
            EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("org.eclipse.birt.chart.event.Image3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Image3DRenderEvent ire = (Image3DRenderEvent)eventObjectCache2.getEventObject(this.oSource, clazz2);
            ire.setLocation3D(this.lo3d);
            ire.setImage(icon);
            this.dc.addPlane(ire, 2);
        } else {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.birt.chart.event.ImageRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageRenderEvent ire = (ImageRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            ire.setLocation(this.lo);
            ire.setImage(icon);
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize)};
            EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache3.getEventObject(this.oSource, clazz3);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(ire, 2, this.iSize);
            } else {
                ipr.drawImage(ire);
            }
        }
    }

    private void drawNabla(IPrimitiveRenderer ipr) throws ChartException {
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - this.iSize - 1.0, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            pre.setDoubleSided(true);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[3];
            if (this.bTransposed) {
                loa[0] = LocationImpl.create(this.lo.getX() + this.iSize - 1.0, this.lo.getY() - this.iSize);
                loa[1] = LocationImpl.create(this.lo.getX() + this.iSize - 1.0, this.lo.getY() + this.iSize);
                loa[2] = LocationImpl.create(this.lo.getX() - this.iSize - 1.0, this.lo.getY());
            } else {
                loa[0] = LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize + 1.0);
                loa[1] = LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - this.iSize + 1.0);
                loa[2] = LocationImpl.create(this.lo.getX(), this.lo.getY() + this.iSize + 1.0);
            }
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawDiamond(IPrimitiveRenderer ipr) throws ChartException {
        double offset = Math.floor(this.iSize);
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - offset, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - offset, this.lo.getY()), LocationImpl.create(this.lo.getX(), this.lo.getY() + offset), LocationImpl.create(this.lo.getX() + offset, this.lo.getY()), LocationImpl.create(this.lo.getX(), this.lo.getY() - offset)};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawFourDiamonds(IPrimitiveRenderer ipr) throws ChartException {
        double offset = Math.floor(0.5 * this.iSize) + 1.0;
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - 2.0 * offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + 2.0 * offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + 2.0 * offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - 2.0 * offset, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            this.preCopy = pre.copy();
            Location3D[] loa1 = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - offset + 1.0, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset - 1.0, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - 2.0 * offset + 1.0, this.lo3d.getZ())};
            EventObjectCache eventObjectCache2 = (EventObjectCache)((Object)ipr);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre1 = (Polygon3DRenderEvent)eventObjectCache2.getEventObject(this.oSource, clazz2);
            pre1.setPoints3D(loa1);
            pre1.setDoubleSided(true);
            pre1.setBackground(this.paletteEntry);
            pre1.setOutline(this.la);
            Location3D[] loa2 = new Location3D[]{Location3DImpl.create(this.lo3d.getX() + 1.0, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() + offset - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + 2.0 * offset - 1.0, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() - offset + 1.0, this.lo3d.getZ())};
            Location3D[] loa3 = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - offset + 1.0, this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + 2.0 * offset - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset - 1.0, this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + 1.0, this.lo3d.getZ())};
            Location3D[] loa4 = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - 2.0 * offset + 1.0, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() + offset - 1.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - 1.0, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() - offset + 1.0, this.lo3d.getZ())};
            this.dc.addPlane(pre1, 3);
            pre1.setPoints3D(loa2);
            this.dc.addPlane(pre1, 3);
            pre1.setPoints3D(loa3);
            this.dc.addPlane(pre1, 3);
            pre1.setPoints3D(loa4);
            this.dc.addPlane(pre1, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - 2.0 * offset, this.lo.getY()), LocationImpl.create(this.lo.getX(), this.lo.getY() + 2.0 * offset), LocationImpl.create(this.lo.getX() + 2.0 * offset, this.lo.getY()), LocationImpl.create(this.lo.getX(), this.lo.getY() - 2.0 * offset)};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            this.preCopy = pre.copy();
            Location[] loa1 = new Location[]{LocationImpl.create(this.lo.getX() - offset + 1.0, this.lo.getY() - offset), LocationImpl.create(this.lo.getX(), this.lo.getY() - 1.0), LocationImpl.create(this.lo.getX() + offset - 1.0, this.lo.getY() - offset), LocationImpl.create(this.lo.getX(), this.lo.getY() - 2.0 * offset + 1.0)};
            EventObjectCache eventObjectCache3 = (EventObjectCache)((Object)ipr);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre1 = (PolygonRenderEvent)eventObjectCache3.getEventObject(this.oSource, clazz3);
            pre1.setPoints(loa1);
            pre1.setBackground(this.paletteEntry);
            pre1.setOutline(this.la);
            Location[] loa2 = new Location[]{LocationImpl.create(this.lo.getX() + 1.0, this.lo.getY()), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() + offset - 1.0), LocationImpl.create(this.lo.getX() + 2.0 * offset - 1.0, this.lo.getY()), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() - offset + 1.0)};
            Location[] loa3 = new Location[]{LocationImpl.create(this.lo.getX() - offset + 1.0, this.lo.getY() + offset), LocationImpl.create(this.lo.getX(), this.lo.getY() + 2.0 * offset - 1.0), LocationImpl.create(this.lo.getX() + offset - 1.0, this.lo.getY() + offset), LocationImpl.create(this.lo.getX(), this.lo.getY() + 1.0)};
            Location[] loa4 = new Location[]{LocationImpl.create(this.lo.getX() - 2.0 * offset + 1.0, this.lo.getY()), LocationImpl.create(this.lo.getX() - offset, this.lo.getY() + offset - 1.0), LocationImpl.create(this.lo.getX() - 1.0, this.lo.getY()), LocationImpl.create(this.lo.getX() - offset, this.lo.getY() - offset + 1.0)};
            if (this.bDeferred) {
                this.dc.addMarker(pre1, 3, this.iSize);
                pre1.setPoints(loa2);
                this.dc.addMarker(pre1, 3, this.iSize);
                pre1.setPoints(loa3);
                this.dc.addMarker(pre1, 3, this.iSize);
                pre1.setPoints(loa4);
                this.dc.addMarker(pre1, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre1);
                ipr.drawPolygon(pre1);
                pre1.setPoints(loa2);
                ipr.fillPolygon(pre1);
                ipr.drawPolygon(pre1);
                pre1.setPoints(loa3);
                ipr.fillPolygon(pre1);
                ipr.drawPolygon(pre1);
                pre1.setPoints(loa4);
                ipr.fillPolygon(pre1);
                ipr.drawPolygon(pre1);
            }
        }
    }

    private void drawCross(IPrimitiveRenderer ipr) throws ChartException {
        double offset = Math.floor(0.5 * this.iSize);
        if (this.bRendering3D) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() + this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() + this.iSize, this.lo3d.getZ())};
            pre3d.setPoints3D(loa);
            pre3d.setDoubleSided(true);
            this.preCopy = pre3d.copy();
            pre3d.setBackground(this.paletteEntry);
            pre3d.setOutline(this.la);
            this.dc.addPlane(pre3d, 3);
        } else {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + offset), LocationImpl.create(this.lo.getX() - offset, this.lo.getY()), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - offset), LocationImpl.create(this.lo.getX() - offset, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX(), this.lo.getY() - offset), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - offset), LocationImpl.create(this.lo.getX() + offset, this.lo.getY()), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + offset), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX(), this.lo.getY() + offset), LocationImpl.create(this.lo.getX() - offset, this.lo.getY() + this.iSize)};
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawEllipse(IPrimitiveRenderer ipr) throws ChartException {
        if (this.bRendering3D) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.birt.chart.event.Oval3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Oval3DRenderEvent ore = (Oval3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            ore.setBackground(this.paletteEntry);
            ore.setOutline(this.la);
            ore.setLocation3D(new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + this.iSize / 2.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - this.iSize / 2.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - this.iSize / 2.0, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + this.iSize / 2.0, this.lo3d.getZ())});
            this.preCopy = ore.copy();
            this.dc.addPlane(ore, 3);
        } else {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.birt.chart.event.OvalRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            OvalRenderEvent ore = (OvalRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            ore.setBackground(this.paletteEntry);
            ore.setBounds(BoundsImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - this.iSize / 2.0, this.iSize * 2.0, this.iSize));
            ore.setOutline(this.la);
            this.preCopy = ore.copy();
            if (this.bDeferred) {
                this.dc.addMarker(ore, 3, this.iSize);
            } else {
                ipr.fillOval(ore);
                ipr.drawOval(ore);
            }
        }
    }

    private void drawSemiCircle(IPrimitiveRenderer ipr) throws ChartException {
        double offset = 0.5 * this.iSize;
        if (this.bRendering3D) {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("org.eclipse.birt.chart.event.Arc3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Arc3DRenderEvent are3d = (Arc3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            are3d.setBackground(this.paletteEntry);
            are3d.setOutline(this.la);
            are3d.setStartAngle(-90.0);
            are3d.setAngleExtent(180.0);
            are3d.setTopLeft3D(Location3DImpl.create(this.lo3d.getX() - this.iSize - offset, this.lo3d.getY() + this.iSize, this.lo3d.getZ()));
            are3d.setHeight(this.iSize);
            are3d.setWidth(this.iSize);
            this.preCopy = are3d.copy();
            this.dc.addPlane(are3d, 3);
        } else {
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.eclipse.birt.chart.event.ArcRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ArcRenderEvent are = (ArcRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            if (this.bTransposed) {
                are.setStartAngle(0.0);
                are.setAngleExtent(180.0);
                are.setBounds(BoundsImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - offset, 2.0 * this.iSize, 2.0 * this.iSize));
            } else {
                are.setStartAngle(-90.0);
                are.setAngleExtent(180.0);
                are.setBounds(BoundsImpl.create(this.lo.getX() - this.iSize - offset, this.lo.getY() - this.iSize, 2.0 * this.iSize, 2.0 * this.iSize));
            }
            are.setBackground(this.paletteEntry);
            are.setOutline(this.la);
            this.preCopy = are.copy();
            if (this.bDeferred) {
                this.dc.addMarker(are, 3, this.iSize);
            } else {
                ipr.fillArc(are);
                ipr.drawArc(are);
            }
        }
    }

    private void drawHexagon(IPrimitiveRenderer ipr) throws ChartException {
        double offset1 = Math.floor(this.iSize * Math.sqrt(3.0) / 2.0);
        double offset2 = Math.floor(0.5 * this.iSize);
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - offset2, this.lo3d.getY() - offset1, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset2, this.lo3d.getY() - offset1, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY(), this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset2, this.lo3d.getY() + offset1, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset2, this.lo3d.getY() + offset1, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY(), this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - offset2, this.lo.getY() - offset1), LocationImpl.create(this.lo.getX() + offset2, this.lo.getY() - offset1), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY()), LocationImpl.create(this.lo.getX() + offset2, this.lo.getY() + offset1), LocationImpl.create(this.lo.getX() - offset2, this.lo.getY() + offset1), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawRectangle(IPrimitiveRenderer ipr) throws ChartException {
        double offset = 0.5 * this.iSize;
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() - offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + this.iSize, this.lo3d.getY() + offset, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - this.iSize, this.lo3d.getY() + offset, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() + offset), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() + offset), LocationImpl.create(this.lo.getX() + this.iSize, this.lo.getY() - offset), LocationImpl.create(this.lo.getX() - this.iSize, this.lo.getY() - offset)};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    private void drawStar(IPrimitiveRenderer ipr) throws ChartException {
        double offsety = this.iSize * Math.tan(Math.toRadians(18.0)) / (Math.tan(Math.toRadians(18.0)) + Math.tan(Math.toRadians(36.0)));
        double offsetx = offsety * Math.tan(Math.toRadians(36.0));
        double offset1 = offsetx + offsetx / Math.sin(Math.toRadians(18.0));
        double offset2 = offsetx + 2.0 * offsetx * Math.sin(Math.toRadians(18.0));
        double offset3 = 2.0 * offsetx * Math.cos(Math.toRadians(18.0)) - offsety;
        double offset4 = 2.0 * offsetx * (1.0 + Math.sin(Math.toRadians(18.0)));
        double offset5 = offset4 / Math.tan(Math.toRadians(18.0)) - this.iSize;
        if (this.bRendering3D) {
            Line3DRenderEvent lre0 = new Line3DRenderEvent(this.oSource);
            lre0.setStart3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + this.iSize, this.lo3d.getZ()));
            lre0.setEnd3D(Location3DImpl.create(this.lo3d.getX() + offsetx, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            Line3DRenderEvent lre1 = new Line3DRenderEvent(this.oSource);
            lre1.setStart3D(Location3DImpl.create(this.lo3d.getX() + offsetx, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            lre1.setEnd3D(Location3DImpl.create(this.lo3d.getX() + offset1, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            Line3DRenderEvent lre2 = new Line3DRenderEvent(this.oSource);
            lre2.setStart3D(Location3DImpl.create(this.lo3d.getX() + offset1, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            lre2.setEnd3D(Location3DImpl.create(this.lo3d.getX() + offset2, this.lo3d.getY() - offset3, this.lo3d.getZ()));
            Line3DRenderEvent lre3 = new Line3DRenderEvent(this.oSource);
            lre3.setStart3D(Location3DImpl.create(this.lo3d.getX() + offset2, this.lo3d.getY() - offset3, this.lo3d.getZ()));
            lre3.setEnd3D(Location3DImpl.create(this.lo3d.getX() + offset4, this.lo3d.getY() - offset5, this.lo3d.getZ()));
            Line3DRenderEvent lre4 = new Line3DRenderEvent(this.oSource);
            lre4.setStart3D(Location3DImpl.create(this.lo3d.getX() + offset4, this.lo3d.getY() - offset5, this.lo3d.getZ()));
            lre4.setEnd3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - offsety / Math.cos(Math.toRadians(18.0)), this.lo3d.getZ()));
            Line3DRenderEvent lre5 = new Line3DRenderEvent(this.oSource);
            lre5.setStart3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() - offsety / Math.cos(Math.toRadians(18.0)), this.lo3d.getZ()));
            lre5.setEnd3D(Location3DImpl.create(this.lo3d.getX() - offset4, this.lo3d.getY() - offset5, this.lo3d.getZ()));
            Line3DRenderEvent lre6 = new Line3DRenderEvent(this.oSource);
            lre6.setStart3D(Location3DImpl.create(this.lo3d.getX() - offset4, this.lo3d.getY() - offset5, this.lo3d.getZ()));
            lre6.setEnd3D(Location3DImpl.create(this.lo3d.getX() - offset2, this.lo3d.getY() - offset3, this.lo3d.getZ()));
            Line3DRenderEvent lre7 = new Line3DRenderEvent(this.oSource);
            lre7.setStart3D(Location3DImpl.create(this.lo3d.getX() - offset2, this.lo3d.getY() - offset3, this.lo3d.getZ()));
            lre7.setEnd3D(Location3DImpl.create(this.lo3d.getX() - offset1, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            Line3DRenderEvent lre8 = new Line3DRenderEvent(this.oSource);
            lre8.setStart3D(Location3DImpl.create(this.lo3d.getX() - offset1, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            lre8.setEnd3D(Location3DImpl.create(this.lo3d.getX() - offsetx, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            Line3DRenderEvent lre9 = new Line3DRenderEvent(this.oSource);
            lre9.setStart3D(Location3DImpl.create(this.lo3d.getX() - offsetx, this.lo3d.getY() + offsety, this.lo3d.getZ()));
            lre9.setEnd3D(Location3DImpl.create(this.lo3d.getX(), this.lo3d.getY() + this.iSize, this.lo3d.getZ()));
            Area3DRenderEvent area3d = new Area3DRenderEvent(this.oSource);
            area3d.add(lre0);
            area3d.add(lre1);
            area3d.add(lre2);
            area3d.add(lre3);
            area3d.add(lre4);
            area3d.add(lre5);
            area3d.add(lre6);
            area3d.add(lre7);
            area3d.add(lre8);
            area3d.add(lre9);
            area3d.setBackground(this.paletteEntry);
            area3d.setOutline(this.la);
            this.preCopy = area3d.copy();
            this.dc.addPlane(area3d, 3);
        } else {
            LineRenderEvent lre0 = new LineRenderEvent(this.oSource);
            lre0.setStart(LocationImpl.create(this.lo.getX(), this.lo.getY() - this.iSize));
            lre0.setEnd(LocationImpl.create(this.lo.getX() + offsetx, this.lo.getY() - offsety));
            LineRenderEvent lre1 = new LineRenderEvent(this.oSource);
            lre1.setStart(LocationImpl.create(this.lo.getX() + offsetx, this.lo.getY() - offsety));
            lre1.setEnd(LocationImpl.create(this.lo.getX() + offset1, this.lo.getY() - offsety));
            LineRenderEvent lre2 = new LineRenderEvent(this.oSource);
            lre2.setStart(LocationImpl.create(this.lo.getX() + offset1, this.lo.getY() - offsety));
            lre2.setEnd(LocationImpl.create(this.lo.getX() + offset2, this.lo.getY() + offset3));
            LineRenderEvent lre3 = new LineRenderEvent(this.oSource);
            lre3.setStart(LocationImpl.create(this.lo.getX() + offset2, this.lo.getY() + offset3));
            lre3.setEnd(LocationImpl.create(this.lo.getX() + offset4, this.lo.getY() + offset5));
            LineRenderEvent lre4 = new LineRenderEvent(this.oSource);
            lre4.setStart(LocationImpl.create(this.lo.getX() + offset4, this.lo.getY() + offset5));
            lre4.setEnd(LocationImpl.create(this.lo.getX(), this.lo.getY() + offsety / Math.cos(Math.toRadians(18.0))));
            LineRenderEvent lre5 = new LineRenderEvent(this.oSource);
            lre5.setStart(LocationImpl.create(this.lo.getX(), this.lo.getY() + offsety / Math.cos(Math.toRadians(18.0))));
            lre5.setEnd(LocationImpl.create(this.lo.getX() - offset4, this.lo.getY() + offset5));
            LineRenderEvent lre6 = new LineRenderEvent(this.oSource);
            lre6.setStart(LocationImpl.create(this.lo.getX() - offset4, this.lo.getY() + offset5));
            lre6.setEnd(LocationImpl.create(this.lo.getX() - offset2, this.lo.getY() + offset3));
            LineRenderEvent lre7 = new LineRenderEvent(this.oSource);
            lre7.setStart(LocationImpl.create(this.lo.getX() - offset2, this.lo.getY() + offset3));
            lre7.setEnd(LocationImpl.create(this.lo.getX() - offset1, this.lo.getY() - offsety));
            LineRenderEvent lre8 = new LineRenderEvent(this.oSource);
            lre8.setStart(LocationImpl.create(this.lo.getX() - offset1, this.lo.getY() - offsety));
            lre8.setEnd(LocationImpl.create(this.lo.getX() - offsetx, this.lo.getY() - offsety));
            LineRenderEvent lre9 = new LineRenderEvent(this.oSource);
            lre9.setStart(LocationImpl.create(this.lo.getX() - offsetx, this.lo.getY() - offsety));
            lre9.setEnd(LocationImpl.create(this.lo.getX(), this.lo.getY() - this.iSize));
            AreaRenderEvent area = new AreaRenderEvent(this.oSource);
            area.add(lre0);
            area.add(lre1);
            area.add(lre2);
            area.add(lre3);
            area.add(lre4);
            area.add(lre5);
            area.add(lre6);
            area.add(lre7);
            area.add(lre8);
            area.add(lre9);
            area.setBackground(this.paletteEntry);
            area.setOutline(this.la);
            this.preCopy = area.copy();
            if (this.bDeferred) {
                this.dc.addMarker(area, 3, this.iSize);
            } else {
                ipr.fillArea(area);
                ipr.drawArea(area);
            }
        }
    }

    private void drawColumn(IPrimitiveRenderer ipr) throws ChartException {
        double offset = 0.5 * this.iSize;
        if (this.bRendering3D) {
            Location3D[] loa = new Location3D[]{Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() - this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() + offset, this.lo3d.getY() + this.iSize, this.lo3d.getZ()), Location3DImpl.create(this.lo3d.getX() - offset, this.lo3d.getY() + this.iSize, this.lo3d.getZ())};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.birt.chart.event.Polygon3DRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Polygon3DRenderEvent pre = (Polygon3DRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints3D(loa);
            pre.setDoubleSided(true);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            this.dc.addPlane(pre, 3);
        } else {
            Location[] loa = new Location[]{LocationImpl.create(this.lo.getX() - offset, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() + this.iSize), LocationImpl.create(this.lo.getX() + offset, this.lo.getY() - this.iSize), LocationImpl.create(this.lo.getX() - offset, this.lo.getY() - this.iSize)};
            EventObjectCache eventObjectCache = (EventObjectCache)((Object)ipr);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.birt.chart.event.PolygonRenderEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PolygonRenderEvent pre = (PolygonRenderEvent)eventObjectCache.getEventObject(this.oSource, clazz);
            pre.setPoints(loa);
            pre.setBackground(this.paletteEntry);
            pre.setOutline(this.la);
            this.preCopy = pre.copy();
            if (this.bDeferred) {
                this.dc.addMarker(pre, 3, this.iSize);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        }
    }

    public PrimitiveRenderEvent getRenderArea() {
        return this.preCopy;
    }
}

