/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.archive.RAInputStream;

public class RAFolderInputStream
extends RAInputStream {
    private RandomAccessFile randomFile;
    private byte[] buf;
    private int bufLen;
    private int bufCur;

    public RAFolderInputStream(File file) throws FileNotFoundException {
        this.randomFile = new RandomAccessFile(file, "r");
        this.buf = new byte[8192];
        this.bufLen = 0;
        this.bufCur = 0;
    }

    public void refresh() throws IOException {
        this.bufLen = 0;
        this.bufCur = 0;
    }

    private void readToBuffer() throws IOException {
        this.bufLen = 0;
        this.bufCur = 0;
        long availableSize = this.randomFile.length() - this.randomFile.getFilePointer();
        if (availableSize <= 0L) {
            return;
        }
        int len = (int)Math.min((long)this.buf.length, availableSize);
        this.bufLen = this.randomFile.read(this.buf, 0, len);
    }

    public int read() throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        return this.buf[this.bufCur++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        while ((count = this.read1(b, off + n, len - n)) >= 0 && (n += count) < len) {
        }
        return n > 0 ? n : -1;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        if (this.bufLen <= 0 || this.bufLen == this.bufCur) {
            this.readToBuffer();
        }
        if (this.bufLen <= 0) {
            return -1;
        }
        int availableSize = this.bufLen - this.bufCur;
        if (len > availableSize) {
            len = availableSize;
        }
        System.arraycopy(this.buf, this.bufCur, b, off, len);
        this.bufCur += len;
        return len;
    }

    public int readInt() throws IOException {
        byte[] ch = new byte[4];
        this.readFully(ch, 0, 4);
        int ret = 0;
        int i = 0;
        while (i < ch.length) {
            ret = ret << 8 & 0xFFFFFF00 | ch[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    public long getStreamLength() throws IOException {
        return this.randomFile.length();
    }

    public void seek(long localPos) throws IOException {
        if (localPos > this.randomFile.getFilePointer() || localPos < this.randomFile.getFilePointer() - (long)this.bufLen) {
            this.randomFile.seek(localPos);
            this.bufCur = 0;
            this.bufLen = 0;
        } else {
            this.bufCur = this.bufLen - (int)(this.randomFile.getFilePointer() - localPos);
        }
    }

    public long getOffset() throws IOException {
        return this.randomFile.getFilePointer() - (long)this.bufLen + (long)this.bufCur;
    }

    public long length() throws IOException {
        return this.getStreamLength();
    }

    public void close() throws IOException {
        this.randomFile.close();
        super.close();
    }

    public int available() throws IOException {
        long availableSize = this.randomFile.length() - this.randomFile.getFilePointer();
        if (availableSize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (availableSize < 0L) {
            return -1;
        }
        return (int)availableSize;
    }
}

