/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.sql.Time;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavascriptEvalUtil {
    private static Logger logger;
    protected static final int SCRIPT_CACHE_SIZE = 200;
    protected static Map compiledScriptCache;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.script.JavascriptEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.core.script.JavascriptEvalUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        compiledScriptCache = Collections.synchronizedMap(new LinkedHashMap(200, 0.75f, true){
            private static final long serialVersionUID = 5787175209573500620L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 200;
            }
        });
    }

    /*
     * Exception decompiling
     */
    public static Object evaluateRawScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 80->83)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object evaluateScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        return JavascriptEvalUtil.convertJavascriptValue(JavascriptEvalUtil.evaluateRawScript(cx, scope, scriptText, source, lineNo));
    }

    protected static Script getCompiledScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) {
        if (!$assertionsDisabled && scriptText == null) {
            throw new AssertionError();
        }
        Script compiledScript = (Script)compiledScriptCache.get(scriptText);
        if (compiledScript == null) {
            compiledScript = cx.compileString(scriptText, source, lineNo, null);
            compiledScriptCache.put(scriptText, compiledScript);
        }
        return compiledScript;
    }

    public static Object convertToJavascriptValue(Object value, Scriptable scope) {
        if (value instanceof Time) {
            return value;
        }
        if (value instanceof Date) {
            Scriptable scriptable;
            Context cx = Context.enter();
            try {
                if (scope == null) {
                    scope = new ImporterTopLevel(cx);
                }
                Long timeVal = new Long(((Date)value).getTime());
                scriptable = ScriptRuntime.newObject((Context)cx, (Scriptable)scope, (String)"Date", (Object[])new Object[]{timeVal});
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return scriptable;
        }
        return value;
    }

    public static Object convertToJavascriptValue(Object value) {
        return JavascriptEvalUtil.convertToJavascriptValue(value, null);
    }

    public static Object convertJavascriptValue(Object inputObj) {
        if (inputObj instanceof Undefined) {
            return null;
        }
        if (inputObj instanceof IdScriptableObject) {
            String jsClass = ((Scriptable)inputObj).getClassName();
            if ("Date".equals(jsClass)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.util.Date");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return Context.toType((Object)inputObj, (Class)clazz);
            }
            if ("Boolean".equals(jsClass)) {
                return new Boolean(Context.toBoolean((Object)inputObj));
            }
            if ("Number".equals(jsClass)) {
                return new Double(Context.toNumber((Object)inputObj));
            }
            if ("String".equals(jsClass)) {
                return inputObj.toString();
            }
            if ("Array".equals(jsClass)) {
                Object[] obj = new Object[(int)((NativeArray)inputObj).getLength()];
                int i = 0;
                while (i < obj.length) {
                    obj[i] = JavascriptEvalUtil.convertJavascriptValue(((NativeArray)inputObj).get(i, null));
                    ++i;
                }
                return obj;
            }
        } else if (inputObj instanceof Wrapper) {
            return ((Wrapper)inputObj).unwrap();
        }
        return inputObj;
    }

    public static BirtException wrapRhinoException(RhinoException e, String scriptText, String source, int lineNo) {
        if (source == null) {
            source = e.sourceName();
            lineNo = e.lineNumber();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unexpected RhinoException. Source=" + source + ", line=" + lineNo + ", Script=\n" + scriptText + "\n", e);
        }
        return new CoreException("birt.core.JavascriptError", new Object[]{e.getLocalizedMessage(), source, new Integer(lineNo), scriptText}, (Throwable)e);
    }

    public static String transformToJsConstants(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

