/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ThreshHoldInfo {
    private Map map = new HashMap();
    private int backRefLevel;
    private boolean isSimple;
    private int forwardRefLevel;

    ThreshHoldInfo(int backRefLevel, int forwardRefLevel, boolean isSimple) {
        this.backRefLevel = backRefLevel;
        this.isSimple = isSimple;
        this.forwardRefLevel = forwardRefLevel;
    }

    void addInfo(String path, String value) {
        this.map.put(path, value);
    }

    String getValue(String rootPath) {
        String nestedXMLPath = this.getCorrespondingNestedXMLColumnPath(rootPath);
        if (nestedXMLPath == null) {
            return null;
        }
        Object value = this.map.get(nestedXMLPath);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String getCorrespondingNestedXMLColumnPath(String rootPath) {
        Iterator it = this.map.keySet().iterator();
        String nestedXMLPath = null;
        while (it.hasNext()) {
            String temp = it.next().toString();
            if (!this.pathMatch(temp, rootPath)) continue;
            nestedXMLPath = temp;
            break;
        }
        return nestedXMLPath;
    }

    private boolean pathMatch(String path, String currentRootPath) {
        if (path == null) {
            return false;
        }
        String[] paths = path.split("/");
        String[] nestedXMLColumnPaths = currentRootPath.split("/");
        int commonRootLen = nestedXMLColumnPaths.length - this.backRefLevel;
        if (commonRootLen < 0 || paths.length != commonRootLen + this.forwardRefLevel) {
            return false;
        }
        int i = 0;
        while (i < commonRootLen) {
            if (!paths[i].startsWith(nestedXMLColumnPaths[i])) {
                return false;
            }
            ++i;
        }
        return !this.isSimple || paths.length == commonRootLen;
    }
}

