/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html.util;

import java.util.List;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class HTMLEmitterUtil {
    public static final int DISPLAY_BLOCK = 1;
    public static final int DISPLAY_FLAG_ALL = 65535;
    public static final int DISPLAY_INLINE = 2;
    public static final int DISPLAY_INLINE_BLOCK = 4;
    public static final int DISPLAY_NONE = 8;
    static final String TYPE_LABEL = "LABEL";
    static final String TYPE_TEMPLATE = "TEMPLATE";
    static final String TYPE_EXTENDED = "EXTENDED";
    static final String TYPE_TABLE = "TABLE";
    static final String TYPE_LIST = "LIST";
    static final String TYPE_DATA = "DATA";
    static final String TYPE_CHART = "CHART";
    static final String TYPE_XTAB = "CROSSTAB";
    static final String TYPE_UNKNOWN;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        TYPE_UNKNOWN = null;
    }

    public static int getElementType(IContent content) {
        return HTMLEmitterUtil.getElementType(content.getX(), content.getY(), content.getWidth(), content.getHeight(), content.getStyle());
    }

    public static String getTagByType(int display, int mask) {
        int flag = display & mask;
        String tag = null;
        if ((flag & 1) > 0) {
            tag = "div";
        }
        if ((flag & 2) > 0) {
            tag = "span";
        }
        return tag;
    }

    public static void setActiveIDTypeIID(HTMLWriter writer, List ouputInstanceIDs, IContent content) {
        String type = HTMLEmitterUtil.getActiveIdType(content);
        if (type != null) {
            InstanceID iid = content.getInstanceID();
            long componentID = iid != null ? iid.getComponentID() : 0L;
            HTMLEmitterUtil.setActiveIDTypeIID(writer, ouputInstanceIDs, content.getBookmark(), type, iid, componentID);
        }
    }

    public static void setActiveIDTypeIID(HTMLWriter writer, List ouputInstanceIDs, String bookmark, String type, InstanceID iid, long elementId) {
        HTMLEmitterUtil.exportElementID(ouputInstanceIDs, bookmark, type, elementId);
        writer.attribute("element_type", type);
        if (iid != null) {
            if (type == TYPE_TABLE || type == TYPE_LIST || type == TYPE_EXTENDED || type == TYPE_CHART || type == TYPE_XTAB) {
                writer.attribute("iid", iid.toUniqueString());
            } else {
                writer.attribute("iid", iid.toString());
            }
        }
    }

    public static void setBookmark(HTMLWriter writer, String tagName, String bookmark) {
        if (tagName == null || !"a".equalsIgnoreCase(tagName)) {
            writer.attribute("id", bookmark);
        } else {
            writer.attribute("id", bookmark);
            writer.attribute("name", bookmark);
        }
    }

    private static void exportElementID(List ouputInstanceIDs, String bookmark, String type, long componentID) {
        if (ouputInstanceIDs != null && bookmark != null) {
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(bookmark);
            buffer.append(",");
            buffer.append(type);
            buffer.append(",");
            buffer.append(componentID);
            ouputInstanceIDs.add(buffer.toString());
        }
    }

    private static String getActiveIdType(IContent content) {
        Object genBy = content.getGenerateBy();
        if (genBy instanceof LabelItemDesign) {
            return TYPE_LABEL;
        }
        if (genBy instanceof TemplateDesign) {
            return TYPE_TEMPLATE;
        }
        if (genBy instanceof ExtendedItemDesign) {
            ExtendedItemDesign extDesign = (ExtendedItemDesign)genBy;
            ExtendedItemHandle extHandle = (ExtendedItemHandle)extDesign.getHandle();
            String extensionName = extHandle.getExtensionName();
            if (TYPE_XTAB.equalsIgnoreCase(extensionName)) {
                return TYPE_XTAB;
            }
            if (TYPE_CHART.equalsIgnoreCase(extensionName)) {
                return TYPE_CHART;
            }
            return TYPE_EXTENDED;
        }
        if (genBy instanceof TableItemDesign) {
            return TYPE_TABLE;
        }
        if (genBy instanceof ListItemDesign) {
            return TYPE_LIST;
        }
        if (genBy instanceof DataItemDesign) {
            return TYPE_DATA;
        }
        return TYPE_UNKNOWN;
    }

    private static int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }
}

