/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.chart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableDataIterator;
import org.eclipse.birt.report.engine.emitter.excel.chart.TableGen;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class ChartConverter {
    protected Logger logger;
    private int ID;
    public final int MAX_STORE = 255;
    static /* synthetic */ Class class$0;

    public ChartConverter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.excel.ExcelEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = Logger.getLogger(clazz.getName());
        this.ID = 1;
        this.MAX_STORE = 255;
    }

    public File convert(ExtendedItemDesign design, ExtendedItemHandle handle) {
        if (this.ID >= 255) {
            return null;
        }
        IReportItem item = null;
        try {
            item = handle.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {}
        if (item == null) {
            try {
                handle.loadExtendedElement();
                item = handle.getReportItem();
            }
            catch (ExtendedElementException e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            if (item == null) {
                return null;
            }
        }
        Chart chart = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        TableDataIterator iter = this.convert(chart);
        try {
            File tempFile = File.createTempFile("Chart" + System.currentTimeMillis(), String.valueOf(this.ID));
            ExcelWriter writer = new ExcelWriter(new FileOutputStream(tempFile));
            writer.startSheet("Chart" + this.ID++);
            writer.startTable(null);
            while (iter.hasNext()) {
                writer.startRow();
                Data[] row = iter.nextRow();
                int i = 0;
                while (i < row.length) {
                    if (row[i] == null) {
                        writer.writeDefaultCell(new Data("", "STRING"));
                    } else {
                        if (row[i].getDatatype() == "DATE") {
                            row[i].setStyleId(1);
                        }
                        writer.writeDefaultCell(row[i]);
                    }
                    ++i;
                }
                writer.endRow();
            }
            writer.endTable();
            writer.closeSheet();
            writer.close(false);
            return tempFile;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public TableDataIterator convert(Chart chart) {
        TableGen table = null;
        table = chart instanceof ChartWithAxes ? this.convertChartWithAxes((ChartWithAxes)chart) : this.covertChart((ChartWithoutAxes)chart);
        return table.iterator();
    }

    private TableGen covertChart(ChartWithoutAxes chart) {
        TableGen table = new TableGen();
        int i = 0;
        while (i < chart.getSeriesDefinitions().size()) {
            SeriesDefinition def = (SeriesDefinition)chart.getSeriesDefinitions().get(i);
            table.addSeriesDefinition(def, null);
            this.walkOnSeriesDefinition(def, table);
            ++i;
        }
        return table;
    }

    private void walkOnSeriesDefinition(SeriesDefinition def, TableGen table) {
        int i = 0;
        while (i < def.getSeriesDefinitions().size()) {
            SeriesDefinition cdef = (SeriesDefinition)def.getSeriesDefinitions().get(i);
            table.addSeriesDefinition(cdef, null);
            this.walkOnSeriesDefinition(cdef, table);
            ++i;
        }
    }

    private TableGen convertChartWithAxes(ChartWithAxes chart) {
        TableGen table = null;
        if (chart.getBaseAxes() != null) {
            table = new TableGen();
            Axis baseAxis = chart.getBaseAxes()[0];
            table.addSeriesDefinition((SeriesDefinition)baseAxis.getSeriesDefinitions().get(0), this.getAxisTitle(baseAxis));
            int i = 0;
            while (i < baseAxis.getAssociatedAxes().size()) {
                Axis assAxis = (Axis)baseAxis.getAssociatedAxes().get(i);
                int j = 0;
                while (j < assAxis.getSeriesDefinitions().size()) {
                    table.addSeriesDefinition((SeriesDefinition)assAxis.getSeriesDefinitions().get(j), this.getAxisTitle(assAxis));
                    ++j;
                }
                ++i;
            }
        }
        return table;
    }

    private String getAxisTitle(Axis axis) {
        return axis.getTitle().getCaption().getValue();
    }
}

