/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;

public class ContentDOMVisitor
extends ContentVisitorAdapter {
    protected IContentEmitter emitter;

    public void emit(IContent content, IContentEmitter emitter) {
        this.emitter = emitter;
        this.visit(content, null);
    }

    public Object visitPage(IPageContent page, Object value) {
        this.emitter.startPage(page);
        this.visitChildren(page.getPageBody(), value);
        this.emitter.endPage(page);
        return value;
    }

    public Object visitContainer(IContainerContent container, Object value) {
        this.emitter.startContainer(container);
        this.visitChildren(container, value);
        this.emitter.endContainer(container);
        return value;
    }

    public Object visitTable(ITableContent table, Object value) {
        this.emitter.startTable(table);
        this.visitChildren(table, value);
        this.emitter.endTable(table);
        return value;
    }

    public Object visitTableGroup(ITableGroupContent group, Object value) {
        this.emitter.startTableGroup(group);
        this.visitChildren(group, value);
        this.emitter.endTableGroup(group);
        return value;
    }

    public Object visitTableBand(ITableBandContent tableBand, Object value) {
        this.emitter.startTableBand(tableBand);
        this.visitChildren(tableBand, value);
        this.emitter.endTableBand(tableBand);
        return value;
    }

    public Object visitRow(IRowContent row, Object value) {
        this.emitter.startRow(row);
        this.visitChildren(row, value);
        this.emitter.endRow(row);
        return value;
    }

    public Object visitCell(ICellContent cell, Object value) {
        this.emitter.startCell(cell);
        this.visitChildren(cell, value);
        this.emitter.endCell(cell);
        return value;
    }

    public Object visitList(IListContent list, Object value) {
        this.emitter.startList(list);
        this.visitChildren(list, value);
        this.emitter.endList(list);
        return value;
    }

    public Object visitListGroup(IListGroupContent group, Object value) {
        this.emitter.startListGroup(group);
        this.visitChildren(group, value);
        this.emitter.endListGroup(group);
        return value;
    }

    public Object visitListBand(IListBandContent listBand, Object value) {
        this.emitter.startListBand(listBand);
        this.visitChildren(listBand, value);
        this.emitter.endListBand(listBand);
        return value;
    }

    public Object visitText(ITextContent text, Object value) {
        this.emitter.startText(text);
        return value;
    }

    public Object visitLabel(ILabelContent label, Object value) {
        this.emitter.startLabel(label);
        return value;
    }

    public Object visitData(IDataContent data, Object value) {
        this.emitter.startData(data);
        return value;
    }

    public Object visitImage(IImageContent image, Object value) {
        this.emitter.startImage(image);
        return value;
    }

    public Object visitForeign(IForeignContent content, Object value) {
        this.emitter.startForeign(content);
        return value;
    }

    protected void visitChildren(IContent container, Object value) {
        Iterator iter = container.getChildren().iterator();
        while (iter.hasNext()) {
            IContent content = (IContent)iter.next();
            this.visit(content, value);
        }
    }
}

