/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.util.HashMap;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;

public class EngineEmitterServices
implements IEmitterServices {
    protected HashMap configs;
    protected IRenderOption renderOptions;
    protected IReportContext reportContext;

    public EngineEmitterServices(IReportContext reportContext, IRenderOption renderOptions, HashMap configs) {
        this.configs = configs;
        this.reportContext = reportContext;
        this.renderOptions = renderOptions;
    }

    public HashMap getEmitterConfig() {
        return this.configs;
    }

    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    public String getReportName() {
        IReportRunnable runnable = this.reportContext.getReportRunnable();
        if (runnable != null) {
            return runnable.getReportName();
        }
        return null;
    }

    public Object getOption(String name) {
        if (this.renderOptions != null) {
            return this.renderOptions.getOption(name);
        }
        return null;
    }

    public Object getRenderContext() {
        if (this.reportContext != null) {
            return this.reportContext.getAppContext();
        }
        return null;
    }

    public IReportRunnable getReportRunnable() {
        if (this.reportContext != null) {
            return this.reportContext.getReportRunnable();
        }
        return null;
    }

    public IReportContext getReportContext() {
        return this.reportContext;
    }
}

