/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;

public abstract class StyledItemExecutor
extends ReportItemExecutor {
    private ExpressionUtil expressionUtil = new ExpressionUtil();

    protected StyledItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void processStyle(ReportItemDesign design, IContent content) {
        StyleDeclaration inlineStyle;
        HighlightDesign highlight = design.getHighlight();
        if (highlight != null && (inlineStyle = this.createHighlightStyle(design.getHighlight())) != null) {
            content.setInlineStyle(inlineStyle);
        }
    }

    protected void processColumnStyle(ColumnDesign columnDesign, IColumn column) {
        StyleDeclaration inlineStyle;
        HighlightDesign highlight = columnDesign.getHighlight();
        if (highlight != null && (inlineStyle = this.createHighlightStyle(highlight)) != null) {
            column.setInlineStyle(inlineStyle);
        }
    }

    private StyleDeclaration createHighlightStyle(HighlightDesign highlight) {
        StyleDeclaration style = (StyleDeclaration)this.report.createStyle();
        int i = 0;
        while (i < highlight.getRuleCount()) {
            HighlightRuleDesign rule = highlight.getRule(i);
            if (rule != null) {
                Object value = null;
                Object expression = rule.getConditionExpr();
                if (expression != null) {
                    value = expression instanceof String ? this.evaluate((String)expression) : this.evaluate((IConditionalExpression)expression);
                } else {
                    IConditionalExpression newExpression = this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                    value = this.evaluate(newExpression);
                }
                if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                    style.setProperties(rule.getStyle());
                }
            }
            ++i;
        }
        return style;
    }

    protected void processMappingValue(StyledElementDesign item, IDataContent dataObj) {
        Object val;
        DataItemHandle dataHandle;
        FactoryPropertyHandle fph;
        MapDesign map = item.getMap();
        if (item instanceof DataItemDesign && ((DataItemDesign)item).needRefreshMapping() && (fph = (dataHandle = (DataItemHandle)item.getHandle()).getFactoryPropertyHandle("mapRules")) != null && (val = fph.getValue()) instanceof List && ((List)val).size() > 0) {
            String testExpr = org.eclipse.birt.core.data.ExpressionUtil.createJSDataExpression((String)dataHandle.getResultSetColumn());
            Iterator itr = ((List)val).iterator();
            while (itr.hasNext()) {
                MapRule mrh = (MapRule)itr.next();
                if (!testExpr.equals(mrh.getTestExpression()) || !"is-null".equals(mrh.getOperator())) continue;
                Object value = null;
                IConditionalExpression newExpression = this.expressionUtil.createConditionalExpression(mrh.getTestExpression(), mrh.getOperator(), mrh.getValue1(), mrh.getValue2());
                value = this.evaluate(newExpression);
                if (value == null || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) break;
                dataObj.setLabelText(mrh.getDisplay());
                dataObj.setLabelKey(mrh.getDisplayKey());
                break;
            }
        }
        if (map != null) {
            int i = 0;
            while (i < map.getRuleCount()) {
                MapRuleDesign rule = map.getRule(i);
                if (rule != null) {
                    Object value = null;
                    Object expression = rule.getConditionExpr();
                    if (expression != null) {
                        value = expression instanceof String ? this.evaluate((String)expression) : this.evaluate((IConditionalExpression)expression);
                    } else {
                        IConditionalExpression newExpression = this.expressionUtil.createConditionalExpression(rule.getTestExpression(), rule.getOperator(), rule.getValue1(), rule.getValue2());
                        value = this.evaluate(newExpression);
                    }
                    if (value != null && value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        dataObj.setLabelText(rule.getDisplayText());
                        dataObj.setLabelKey(rule.getDisplayKey());
                    }
                }
                ++i;
            }
        }
    }
}

