/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ExtendedGenerateExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;

public class ExtensionManager {
    protected static Logger logger;
    public static final String EXTENSION_POINT_EMITTERS = "org.eclipse.birt.report.engine.emitters";
    public static final String EXTENSION_POINT_GENERATION = "org.eclipse.birt.report.engine.reportitemGeneration";
    public static final String EXTENSION_POINT_PRESENTATION = "org.eclipse.birt.report.engine.reportitemPresentation";
    public static final String EXTENSION_POINT_QUERY = "org.eclipse.birt.report.engine.reportitemQuery";
    protected static ExtensionManager sm_instance;
    protected HashMap generationExtensions = new HashMap();
    protected HashMap presentationExtensions = new HashMap();
    protected HashMap queryExtensions = new HashMap();
    protected ArrayList emitterExtensions = new ArrayList();
    protected HashMap formats = new HashMap();
    protected HashMap emitters = new HashMap();
    public static final String PAGE_BREAK_PAGINATION = "page-break-pagination";
    public static final String PAPER_SIZE_PAGINATION = "paper-size-pagination";
    public static final String NO_PAGINATION = "no-pagination";
    public static final Boolean DEFAULT_OUTPUT_DISPLAY_NONE;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.extension.internal.ExtensionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.extension.internal.ExtensionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        DEFAULT_OUTPUT_DISPLAY_NONE = new Boolean(false);
    }

    ExtensionManager() {
        this.loadGenerationExtensionDefns();
        this.loadPresentationExtensionDefns();
        this.loadQueryExtensionDefns();
        this.loadEmitterExtensionDefns();
    }

    private static synchronized void createInstance() {
        if (sm_instance == null) {
            sm_instance = new ExtensionManager();
        }
    }

    public static ExtensionManager getInstance() {
        if (sm_instance == null) {
            ExtensionManager.createInstance();
        }
        return sm_instance;
    }

    public IReportItemExecutor createReportItemExecutor(ExecutorManager manager, String itemType) {
        IConfigurationElement config = (IConfigurationElement)this.generationExtensions.get(itemType);
        if (config != null) {
            Object object = this.createObject(config, "class");
            if (object instanceof IReportItemExecutor) {
                return (IReportItemExecutor)object;
            }
            if (object instanceof IReportItemGeneration) {
                return new ExtendedGenerateExecutor(manager, (IReportItemGeneration)object);
            }
            logger.log(Level.WARNING, "Create Report Item Executor fail, Config not exist class: {0}", config.getName());
        }
        return new ExtendedGenerateExecutor(manager, null);
    }

    public IReportItemPresentation createPresentationItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.presentationExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemPresentation) {
            return (IReportItemPresentation)object;
        }
        return null;
    }

    public IReportItemQuery createQueryItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.queryExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemQuery) {
            return (IReportItemQuery)object;
        }
        return null;
    }

    public boolean getAllRows(String itemType) {
        IConfigurationElement config = (IConfigurationElement)this.queryExtensions.get(itemType);
        if (config != null) {
            return Boolean.valueOf(config.getAttribute("getAllRows"));
        }
        return false;
    }

    public IContentEmitter createEmitter(String format, String id) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        int i = 0;
        while (i < this.emitterExtensions.size()) {
            EmitterInfo emitterInfo = (EmitterInfo)this.emitterExtensions.get(i);
            if (format.equalsIgnoreCase(emitterInfo.getFormat()) && (id == null || id != null && id.equalsIgnoreCase(emitterInfo.getID()))) {
                config = emitterInfo.getEmitter();
                break;
            }
            ++i;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public IContentEmitter createEmitter(String format) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        int i = 0;
        while (i < this.emitterExtensions.size()) {
            EmitterInfo emitterInfo = (EmitterInfo)this.emitterExtensions.get(i);
            if (format.equalsIgnoreCase(emitterInfo.getFormat())) {
                config = emitterInfo.getEmitter();
                break;
            }
            ++i;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public Collection getSupportedFormat() {
        return this.formats.keySet();
    }

    public EmitterInfo[] getEmitterInfo() {
        EmitterInfo[] infos = new EmitterInfo[this.emitters.size()];
        Object[] keys = this.emitters.keySet().toArray();
        int index = 0;
        int length = keys.length;
        while (index < length) {
            infos[index] = (EmitterInfo)this.emitters.get(keys[index].toString());
            ++index;
        }
        return infos;
    }

    protected Object createObject(IConfigurationElement config, String property) {
        block3: {
            try {
                Object object;
                String value = config.getAttribute(property);
                if (value != null && (object = config.createExecutableExtension(property)) != null) {
                    return object;
                }
            }
            catch (FrameworkException frameworkException) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Can not instantiate class {0} with property {1}.", new String[]{config.getAttribute("class"), property});
            }
        }
        return null;
    }

    protected void loadGenerationExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_GENERATION);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_GENERATION);
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.generationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load generation extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadPresentationExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_PRESENTATION);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_PRESENTATION);
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.presentationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load prsentation extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadQueryExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_QUERY);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_QUERY);
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.queryExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load query extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadEmitterExtensionDefns() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_EMITTERS);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", EXTENSION_POINT_EMITTERS);
        int i = 0;
        while (i < exts.length) {
            String namespace = exts[i].getNamespace();
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String format = configs[j].getAttribute("format");
                String mimeType = configs[j].getAttribute("mimeType");
                String id = configs[j].getAttribute("id");
                String pagination = configs[j].getAttribute("pagination");
                String icon = configs[j].getAttribute("icon");
                Boolean outDisplayNone = new Boolean(configs[j].getAttribute("outputDisplayNone"));
                EmitterInfo emitterInfo = new EmitterInfo(format, id, pagination, mimeType, icon, namespace, outDisplayNone, configs[j]);
                this.emitterExtensions.add(emitterInfo);
                if (!$assertionsDisabled && format == null) {
                    throw new AssertionError();
                }
                this.formats.put(format.toLowerCase(), emitterInfo);
                this.emitters.put(id, emitterInfo);
                logger.log(Level.FINE, "Load {0} emitter {1}", new String[]{format, id});
                ++j;
            }
            ++i;
        }
    }

    public String getMIMEType(String format) {
        if (format != null) {
            format = format.toLowerCase();
        }
        if (this.formats.containsKey(format)) {
            return ((EmitterInfo)this.formats.get(format)).getMimeType();
        }
        return null;
    }

    public String getPagination(String format) {
        if (format != null) {
            format = format.toLowerCase();
        }
        if (this.formats.containsKey(format)) {
            return ((EmitterInfo)this.formats.get(format)).getPagination();
        }
        return PAGE_BREAK_PAGINATION;
    }

    public Boolean getOutputDisplayNone(String format) {
        if (format != null) {
            format = format.toLowerCase();
        }
        if (this.formats.containsKey(format)) {
            return ((EmitterInfo)this.formats.get(format)).getOutputDisplayNone();
        }
        return DEFAULT_OUTPUT_DISPLAY_NONE;
    }
}

