/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.ReportExecutorWrapper;
import org.eclipse.birt.report.engine.internal.document.v3.ReportExecutorV3;

public class ReportExecutor
extends ReportExecutorWrapper {
    public ReportExecutor(ExecutionContext context) throws BirtException {
        try {
            int version = ReportExecutor.getVersion(context.getReportDocument());
            switch (version) {
                case 3: {
                    this.executor = new ReportExecutorV3(context);
                    break;
                }
                case 4: {
                    this.executor = new ReportExecutorV3(context);
                    break;
                }
                default: {
                    throw new EngineException("unsupported document version:" + version);
                }
            }
        }
        catch (IOException ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
    }
}

