/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class AbstractArea
implements IArea {
    protected IStyle style;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected IContent content;
    protected boolean hasStyle = false;
    protected float scale = 1.0f;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.area.impl.AbstractArea");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    AbstractArea(IContent content) {
        this.content = content;
        if (content != null) {
            this.style = new AreaStyle((ComputedStyle)content.getComputedStyle());
            this.hasStyle = !content.getStyle().isEmpty();
        } else {
            this.style = new AreaStyle(new BIRTCSSEngine());
        }
    }

    AbstractArea(IReportContent report) {
        if (report != null) {
            if (!$assertionsDisabled && !(report instanceof ReportContent)) {
                throw new AssertionError();
            }
            this.style = new AreaStyle(((ReportContent)report).getCSSEngine());
        } else {
            this.style = new AreaStyle(new BIRTCSSEngine());
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public void setAllocatedPosition(int ax, int ay) {
        if (this.hasStyle) {
            this.x = ax + PropertyUtil.getDimensionValue(this.style.getProperty(31));
            this.y = ay + PropertyUtil.getDimensionValue(this.style.getProperty(53));
        } else {
            this.x = ax;
            this.y = ay;
        }
    }

    public void setAllocatedHeight(int aHeight) {
        this.height = this.hasStyle ? aHeight - PropertyUtil.getDimensionValue(this.style.getProperty(53)) - PropertyUtil.getDimensionValue(this.style.getProperty(52)) : aHeight;
    }

    public void setAllocatedWidth(int aWidth) {
        if (this.hasStyle) {
            int totalMarginWidth = PropertyUtil.getDimensionValue(this.style.getProperty(31)) + PropertyUtil.getDimensionValue(this.style.getProperty(32));
            if (totalMarginWidth >= aWidth) {
                this.style.setProperty(31, IStyle.NUMBER_0);
                this.style.setProperty(32, IStyle.NUMBER_0);
                this.width = aWidth;
            } else {
                this.width = aWidth - totalMarginWidth;
            }
        } else {
            this.width = aWidth;
        }
    }

    public void setContentHeight(int cHeight) {
        this.height = this.hasStyle ? cHeight + PropertyUtil.getDimensionValue(this.style.getProperty(15)) + PropertyUtil.getDimensionValue(this.style.getProperty(19)) + PropertyUtil.getDimensionValue(this.style.getProperty(56)) + PropertyUtil.getDimensionValue(this.style.getProperty(55)) : cHeight;
    }

    public void setContentWidth(int cWidth) {
        this.width = this.hasStyle ? cWidth + PropertyUtil.getDimensionValue(this.style.getProperty(17)) + PropertyUtil.getDimensionValue(this.style.getProperty(18)) + PropertyUtil.getDimensionValue(this.style.getProperty(36)) + PropertyUtil.getDimensionValue(this.style.getProperty(37)) : cWidth;
    }

    public int getAllocatedX() {
        if (this.hasStyle) {
            return this.x - PropertyUtil.getDimensionValue(this.style.getProperty(31));
        }
        return this.x;
    }

    public int getAllocatedY() {
        if (this.hasStyle) {
            return this.y - PropertyUtil.getDimensionValue(this.style.getProperty(53));
        }
        return this.y;
    }

    public int getContentWidth() {
        if (this.hasStyle) {
            int totalPaddngWidth = PropertyUtil.getDimensionValue(this.style.getProperty(36)) + PropertyUtil.getDimensionValue(this.style.getProperty(37));
            int totalBorderWidth = PropertyUtil.getDimensionValue(this.style.getProperty(17)) + PropertyUtil.getDimensionValue(this.style.getProperty(18));
            if (this.width <= totalPaddngWidth) {
                this.style.setProperty(36, IStyle.NUMBER_0);
                this.style.setProperty(37, IStyle.NUMBER_0);
                return this.width - totalBorderWidth;
            }
            return this.width - totalPaddngWidth - totalBorderWidth;
        }
        return this.width;
    }

    public int getContentHeight() {
        if (this.hasStyle) {
            return this.height - PropertyUtil.getDimensionValue(this.style.getProperty(15)) - PropertyUtil.getDimensionValue(this.style.getProperty(19)) - PropertyUtil.getDimensionValue(this.style.getProperty(56)) - PropertyUtil.getDimensionValue(this.style.getProperty(55));
        }
        return this.height;
    }

    public int getAllocatedWidth() {
        if (this.hasStyle) {
            return this.width + PropertyUtil.getDimensionValue(this.style.getProperty(31)) + PropertyUtil.getDimensionValue(this.style.getProperty(32));
        }
        return this.width;
    }

    public int getAllocatedHeight() {
        if (this.hasStyle) {
            return this.height + PropertyUtil.getDimensionValue(this.style.getProperty(53)) + PropertyUtil.getDimensionValue(this.style.getProperty(52));
        }
        return this.height;
    }

    public IStyle getStyle() {
        return this.style;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public IContent getContent() {
        return this.content;
    }

    protected void removeMargin() {
        if (this.hasStyle) {
            this.style.setProperty(31, IStyle.NUMBER_0);
            this.style.setProperty(32, IStyle.NUMBER_0);
            this.style.setProperty(53, IStyle.NUMBER_0);
            this.style.setProperty(52, IStyle.NUMBER_0);
        }
    }

    protected void removeBorder() {
        if (this.hasStyle) {
            this.style.setProperty(15, IStyle.NUMBER_0);
            this.style.setProperty(19, IStyle.NUMBER_0);
            this.style.setProperty(17, IStyle.NUMBER_0);
            this.style.setProperty(18, IStyle.NUMBER_0);
        }
    }

    protected void removePadding() {
        if (this.hasStyle) {
            this.style.setProperty(36, IStyle.NUMBER_0);
            this.style.setProperty(37, IStyle.NUMBER_0);
            this.style.setProperty(56, IStyle.NUMBER_0);
            this.style.setProperty(55, IStyle.NUMBER_0);
        }
    }
}

