/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLStyleProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.TableProcessor;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSValue;

public class HTML2Content {
    protected static final HashSet htmlDisplayMode = new HashSet();
    protected static final HashMap textTypeMapping = new HashMap();

    static {
        htmlDisplayMode.add("dd");
        htmlDisplayMode.add("div");
        htmlDisplayMode.add("dl");
        htmlDisplayMode.add("dt");
        htmlDisplayMode.add("h1");
        htmlDisplayMode.add("h2");
        htmlDisplayMode.add("h3");
        htmlDisplayMode.add("h4");
        htmlDisplayMode.add("h5");
        htmlDisplayMode.add("h6");
        htmlDisplayMode.add("hr");
        htmlDisplayMode.add("ol");
        htmlDisplayMode.add("p");
        htmlDisplayMode.add("pre");
        htmlDisplayMode.add("ul");
        htmlDisplayMode.add("li");
        htmlDisplayMode.add("address");
        htmlDisplayMode.add("body");
        htmlDisplayMode.add("center");
        htmlDisplayMode.add("table");
        textTypeMapping.put("text/html", TextParser.TEXT_TYPE_HTML);
        textTypeMapping.put("text/plaintext", TextParser.TEXT_TYPE_PLAIN);
        textTypeMapping.put("binary/unknown", TextParser.TEXT_TYPE_AUTO);
    }

    public static void html2Content(IForeignContent foreign) {
        HTML2Content.processForeignData(foreign);
    }

    protected static void processForeignData(IForeignContent foreign) {
        Node node;
        if (foreign.getChildren() != null && foreign.getChildren().size() > 0) {
            return;
        }
        HashMap styleMap = new HashMap();
        ReportDesignHandle reportDesign = foreign.getReportContent().getDesign().getReportDesign();
        HTMLStyleProcessor htmlProcessor = new HTMLStyleProcessor(reportDesign);
        Object rawValue = foreign.getRawValue();
        Node doc = null;
        if (rawValue != null) {
            doc = new TextParser().parse(foreign.getRawValue().toString(), (String)textTypeMapping.get(foreign.getRawType()));
        }
        Element body = null;
        if (doc != null && (node = doc.getFirstChild()) instanceof Element) {
            body = (Element)node;
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap);
            ContainerContent container = new ContainerContent((ReportContent)foreign.getReportContent());
            HTML2Content.addChild(foreign, container, null);
            HTML2Content.processNodes(body, styleMap, container, null, null);
        }
    }

    static void processNodes(Element ele, Map cssStyles, IContent content, IContent inlineParent, ActionContent action) {
        int level = 0;
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("value-of")) {
                if (node.getFirstChild() instanceof Element) {
                    HTML2Content.processNodes((Element)node.getFirstChild(), cssStyles, content, inlineParent, action);
                }
            } else if (node.getNodeName().equals("image")) {
                if (node.getFirstChild() instanceof Element) {
                    HTML2Content.processNodes((Element)node.getFirstChild(), cssStyles, content, inlineParent, action);
                }
            } else if (node.getNodeType() == 3) {
                LabelContent label = new LabelContent((ReportContent)content.getReportContent());
                HTML2Content.addChild(content, label, inlineParent);
                label.setText(node.getNodeValue());
                StyleDeclaration inlineStyle = new StyleDeclaration(content.getCSSEngine());
                inlineStyle.setProperty(33, CSSValueConstants.INLINE_VALUE);
                label.setInlineStyle(inlineStyle);
                if (action != null) {
                    label.setHyperlinkAction(action);
                }
            } else if (node.getNodeType() == 1) {
                HTML2Content.handleElement((Element)node, cssStyles, content, inlineParent, action, ++level);
            }
            node = node.getNextSibling();
        }
    }

    static void handleElement(Element ele, Map cssStyles, IContent content, IContent inlineParent, ActionContent action, int index) {
        IStyle cssStyle = (IStyle)cssStyles.get(ele);
        if (cssStyle != null && "none".equals(cssStyle.getDisplay())) {
            return;
        }
        String tagName = ele.getTagName();
        if (tagName.toLowerCase().equals("a")) {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            HTML2Content.setInlineParent(content, container, inlineParent);
            HTML2Content.handleStyle(ele, cssStyles, container);
            ActionContent actionContent = HTML2Content.handleAnchor(ele, container, action);
            HTML2Content.processNodes(ele, cssStyles, content, container, actionContent);
        } else if (tagName.toLowerCase().equals("img")) {
            HTML2Content.outputImg(ele, cssStyles, content, inlineParent);
        } else if (tagName.toLowerCase().equals("br")) {
            LabelContent label = new LabelContent((ReportContent)content.getReportContent());
            HTML2Content.addChild(content, label, inlineParent);
            label.setText("\n");
            StyleDeclaration inlineStyle = new StyleDeclaration(content.getCSSEngine());
            inlineStyle.setProperty(33, CSSValueConstants.INLINE_VALUE);
            label.setInlineStyle(inlineStyle);
        } else if (tagName.toLowerCase().equals("li") && ele.getParentNode().getNodeType() == 1) {
            StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
            style.setProperty(33, CSSValueConstants.BLOCK_VALUE);
            style.setProperty(30, CSSValueConstants.MIDDLE_VALUE);
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            container.setInlineStyle(style);
            HTML2Content.addChild(content, container, inlineParent);
            HTML2Content.handleStyle(ele, cssStyles, container);
            style = new StyleDeclaration(content.getCSSEngine());
            style.setProperty(33, CSSValueConstants.INLINE_VALUE);
            style.setProperty(30, CSSValueConstants.TOP_VALUE);
            ContainerContent orderContainer = new ContainerContent((ReportContent)content.getReportContent());
            CSSValue fontSizeValue = content.getComputedStyle().getProperty(38);
            orderContainer.setWidth(new DimensionType(2.1 * (double)PropertyUtil.getDimensionValue(fontSizeValue) / 1000.0, "pt"));
            orderContainer.setInlineStyle(style);
            HTML2Content.addChild(container, orderContainer, inlineParent);
            TextContent text = new TextContent((ReportContent)content.getReportContent());
            HTML2Content.addChild(orderContainer, text, inlineParent);
            if (ele.getParentNode().getNodeName().equals("ol")) {
                text.setText(String.valueOf(new Integer(index).toString()) + ".");
            } else if (ele.getParentNode().getNodeName().equals("ul")) {
                text.setText(new String(new char[]{'\u2022'}));
            }
            text.setInlineStyle(style);
            ContainerContent childContainer = new ContainerContent((ReportContent)content.getReportContent());
            HTML2Content.addChild(container, childContainer, inlineParent);
            childContainer.setInlineStyle(style);
            HTML2Content.processNodes(ele, cssStyles, childContainer, inlineParent, action);
        } else if (tagName.toLowerCase().equals("dd") || tagName.toLowerCase().equals("dt")) {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            HTML2Content.addChild(content, container, inlineParent);
            HTML2Content.handleStyle(ele, cssStyles, container);
            if (tagName.toLowerCase().equals("dd")) {
                StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
                style.setProperty(33, CSSValueConstants.INLINE_VALUE);
                style.setProperty(30, CSSValueConstants.TOP_VALUE);
                TextContent text = new TextContent((ReportContent)content.getReportContent());
                HTML2Content.addChild(content, text, inlineParent);
                if (ele.getParentNode().getNodeName().equals("dl")) {
                    text.setText("");
                }
                style.setTextIndent("3em");
                text.setInlineStyle(style);
                ContainerContent childContainer = new ContainerContent((ReportContent)content.getReportContent());
                childContainer.setInlineStyle(style);
                HTML2Content.addChild(container, childContainer, inlineParent);
                HTML2Content.processNodes(ele, cssStyles, container, inlineParent, action);
            } else {
                HTML2Content.processNodes(ele, cssStyles, container, inlineParent, action);
            }
        } else if ("table".equals(tagName.toLowerCase())) {
            TableProcessor.processTable(ele, cssStyles, content, inlineParent, action);
        } else {
            ContainerContent container = new ContainerContent((ReportContent)content.getReportContent());
            HTML2Content.handleStyle(ele, cssStyles, container);
            if (htmlDisplayMode.contains(ele.getTagName())) {
                HTML2Content.addChild(content, container, inlineParent);
                HTML2Content.processNodes(ele, cssStyles, container, inlineParent, action);
            } else {
                HTML2Content.setInlineParent(content, container, inlineParent);
                HTML2Content.processNodes(ele, cssStyles, content, container, action);
            }
        }
    }

    private static boolean checkEscapeSpace(Node doc) {
        String textType = null;
        if (doc != null && doc.getFirstChild() != null && doc.getFirstChild() instanceof Element) {
            textType = ((Element)doc.getFirstChild()).getAttribute("text-type");
            return !TextParser.TEXT_TYPE_HTML.equalsIgnoreCase(textType);
        }
        return true;
    }

    protected static ActionContent handleAnchor(Element ele, IContent content, ActionContent defaultAction) {
        String href;
        ActionContent result = defaultAction;
        if (ele.getAttribute("id").trim().length() != 0) {
            content.setBookmark(ele.getAttribute("id"));
        } else {
            content.setBookmark(ele.getAttribute("name"));
        }
        if (ele.getAttribute("href").length() > 0 && (href = ele.getAttribute("href")) != null && !"".equals(href)) {
            ActionContent action = new ActionContent();
            if (href.startsWith("#")) {
                action.setBookmark(href.substring(1));
            } else {
                String target = ele.getAttribute("target");
                if ("".equals(target)) {
                    target = "_blank";
                }
                action.setHyperlink(href, target);
            }
            result = action;
        }
        return result;
    }

    static void handleStyle(Element ele, Map cssStyles, IContent content) {
        StyleProcessor tag2Style;
        String tagName = ele.getTagName();
        StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
        if ("font".equals(tagName)) {
            String attr = ele.getAttribute("size");
            if (attr != null && !"".equals(attr)) {
                style.setFontSize(attr);
            }
            if ((attr = ele.getAttribute("color")) != null && !"".equals(attr)) {
                style.setColor(attr);
            }
            if ((attr = ele.getAttribute("face")) != null && !"".equals(attr)) {
                style.setFontFamily(attr);
            }
        }
        if (htmlDisplayMode.contains(tagName)) {
            style.setDisplay("block");
        } else {
            style.setDisplay("inline");
        }
        IStyle inlineStyle = (IStyle)cssStyles.get(ele);
        if (inlineStyle != null) {
            style.setProperties(inlineStyle);
        }
        if ((tag2Style = StyleProcessor.getStyleProcess(tagName)) != null) {
            tag2Style.process(style);
        }
        content.setInlineStyle(style);
    }

    protected static void outputImg(Element ele, Map cssStyles, IContent content, IContent inlineParent) {
        String src = ele.getAttribute("src");
        if (src != null) {
            ImageContent image = new ImageContent(content);
            HTML2Content.addChild(content, image, inlineParent);
            HTML2Content.handleStyle(ele, cssStyles, image);
            if (!FileUtil.isLocalResource(src)) {
                image.setImageSource(3);
                image.setURI(src);
            } else {
                ReportDesignHandle handle = content.getReportContent().getDesign().getReportDesign();
                URL url = handle.findResource(src, 1);
                if (url != null) {
                    src = url.toString();
                }
                image.setImageSource(0);
                image.setURI(src);
            }
            if (ele.getAttribute("width") != null && !"".equals(ele.getAttribute("width"))) {
                image.setWidth(PropertyUtil.getDimensionAttribute(ele, "width"));
            }
            if (ele.getAttribute("height") != null && !"".equals(ele.getAttribute("height"))) {
                image.setHeight(PropertyUtil.getDimensionAttribute(ele, "height"));
            }
            if (ele.getAttribute("alt") != null && !"".equals(ele.getAttribute("alt"))) {
                image.setAltText(ele.getAttribute("alt"));
            }
        }
    }

    protected static void addChild(IContent parent, IContent child, IContent inlineParent) {
        Collection children;
        if (parent != null && child != null && !(children = parent.getChildren()).contains(child)) {
            children.add(child);
            if (inlineParent == null) {
                child.setParent(parent);
            } else {
                child.setParent(inlineParent);
            }
        }
    }

    protected static void setInlineParent(IContent parent, IContent child, IContent inlineParent) {
        if (parent != null && child != null) {
            if (inlineParent == null) {
                child.setParent(parent);
            } else {
                child.setParent(inlineParent);
            }
        }
    }
}

